/*
 * Decompiled with CFR 0.152.
 */
package com.github.arteam.simplejsonrpc.server;

import com.github.arteam.simplejsonrpc.core.annotation.JsonRpcErrorData;
import com.github.arteam.simplejsonrpc.core.annotation.JsonRpcMethod;
import com.github.arteam.simplejsonrpc.core.annotation.JsonRpcOptional;
import com.github.arteam.simplejsonrpc.core.annotation.JsonRpcParam;
import com.github.arteam.simplejsonrpc.core.annotation.JsonRpcService;
import com.github.arteam.simplejsonrpc.server.JsonRpcServer;
import com.github.arteam.simplejsonrpc.server.metadata.ClassMetadata;
import com.github.arteam.simplejsonrpc.server.metadata.ErrorDataResolver;
import com.github.arteam.simplejsonrpc.server.metadata.MethodMetadata;
import com.github.arteam.simplejsonrpc.server.metadata.ParameterMetadata;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Reflections {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcServer.class);
    private static final MethodHandles.Lookup METHOD_HANDLES_LOOKUP = MethodHandles.lookup();

    private Reflections() {
    }

    @Nullable
    public static <T extends Annotation> T getAnnotation(@Nullable Annotation[] annotations, Class<T> clazz) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (annotation == null || !annotation.annotationType().equals(clazz)) continue;
                return (T)annotation;
            }
        }
        return null;
    }

    public static ClassMetadata getClassMetadata(Class<?> clazz) {
        ImmutableMap.Builder methodsMetadata = ImmutableMap.builder();
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            for (Method method : searchType.getDeclaredMethods()) {
                MethodHandle methodHandle;
                String methodName = method.getName();
                JsonRpcMethod jsonRpcMethod = Reflections.getAnnotation(method.getDeclaredAnnotations(), JsonRpcMethod.class);
                if (jsonRpcMethod == null) continue;
                int modifiers = method.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    log.warn("Method '" + methodName + "' is not public");
                    continue;
                }
                if (Modifier.isStatic(modifiers)) {
                    log.warn("Method '" + methodName + "' is static");
                    continue;
                }
                String rpcMethodName = !jsonRpcMethod.value().isEmpty() ? jsonRpcMethod.value() : methodName;
                ImmutableMap<String, ParameterMetadata> methodParams = Reflections.getMethodParameters(method);
                if (methodParams == null) {
                    log.warn("Method '" + methodName + "' has misconfigured parameters");
                    continue;
                }
                method.setAccessible(true);
                try {
                    methodHandle = METHOD_HANDLES_LOOKUP.unreflect(method);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                methodsMetadata.put((Object)rpcMethodName, (Object)new MethodMetadata(rpcMethodName, methodHandle, methodParams));
            }
        }
        boolean isService = Reflections.getAnnotation(clazz != null ? clazz.getAnnotations() : null, JsonRpcService.class) != null;
        try {
            return new ClassMetadata(isService, (ImmutableMap<String, MethodMetadata>)methodsMetadata.build());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("There two methods with the same name in " + clazz, e);
        }
    }

    @Nullable
    private static ImmutableMap<String, ParameterMetadata> getMethodParameters(Method method) {
        Annotation[][] allParametersAnnotations = method.getParameterAnnotations();
        int methodParamsSize = allParametersAnnotations.length;
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        ImmutableMap.Builder parametersMetadata = ImmutableMap.builder();
        for (int i = 0; i < methodParamsSize; ++i) {
            Annotation[] parameterAnnotations = allParametersAnnotations[i];
            JsonRpcParam jsonRpcParam = Reflections.getAnnotation(parameterAnnotations, JsonRpcParam.class);
            if (jsonRpcParam == null) {
                log.warn("Annotation @JsonRpcParam is not set for the " + i + " parameter of a method '" + method.getName() + "'");
                return null;
            }
            String paramName = jsonRpcParam.value();
            boolean optional = Reflections.getAnnotation(parameterAnnotations, JsonRpcOptional.class) != null;
            parametersMetadata.put((Object)paramName, (Object)new ParameterMetadata(paramName, parameterTypes[i], genericParameterTypes[i], i, optional));
        }
        try {
            return parametersMetadata.build();
        }
        catch (IllegalArgumentException e) {
            log.error("There two parameters with the same name in method '" + method.getName() + "' of the class '" + method.getDeclaringClass() + "'", (Throwable)e);
            return null;
        }
    }

    static ErrorDataResolver buildErrorDataResolver(Class<? extends Throwable> throwableClass) {
        MethodHandle dataField = null;
        MethodHandle dataMethod = null;
        for (Class<? extends Throwable> c = throwableClass; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(JsonRpcErrorData.class)) continue;
                if (dataField != null) {
                    throw new IllegalArgumentException("Ambiguous configuration: there is more than one @JsonRpcErrorData annotated property in " + c.getName());
                }
                field.setAccessible(true);
                try {
                    dataField = METHOD_HANDLES_LOOKUP.unreflectGetter(field);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if (!accessibleObject.isAnnotationPresent(JsonRpcErrorData.class)) continue;
                if (((Method)accessibleObject).getReturnType() == Void.TYPE) {
                    log.warn("Method '{}' annotated with 'JsonRpcErrorData' cannot have void return type", (Object)((Method)accessibleObject).getName());
                    continue;
                }
                if (((Method)accessibleObject).getParameterCount() > 0) {
                    log.warn("Method '{}' annotated with 'JsonRpcErrorData' must be with zero arguments", (Object)((Method)accessibleObject).getName());
                    continue;
                }
                if (dataField != null || dataMethod != null) {
                    throw new IllegalArgumentException("Ambiguous configuration: there is more than one @JsonRpcErrorData annotated property in " + c.getName());
                }
                ((Method)accessibleObject).setAccessible(true);
                try {
                    dataMethod = METHOD_HANDLES_LOOKUP.unreflect((Method)accessibleObject);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (dataField != null) {
            MethodHandle finalDataField = dataField;
            return t -> {
                try {
                    return Optional.ofNullable(finalDataField.invoke(t));
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            };
        }
        if (dataMethod != null) {
            MethodHandle finalDataMethod = dataMethod;
            return t -> {
                try {
                    return Optional.ofNullable(finalDataMethod.invoke(t));
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            };
        }
        return t -> Optional.empty();
    }
}

