/*
 * Decompiled with CFR 0.152.
 */
package apidiff.internal.analysis;

import apidiff.Result;
import apidiff.internal.analysis.DiffProcessor;
import apidiff.internal.analysis.FieldDiff;
import apidiff.internal.analysis.MethodDiff;
import apidiff.internal.analysis.TypeDiff;
import apidiff.internal.refactor.RefactoringProcessorImpl;
import apidiff.internal.visitor.APIVersion;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import refdiff.core.api.RefactoringType;
import refdiff.core.rm2.model.refactoring.SDRefactoring;

public class DiffProcessorImpl
implements DiffProcessor {
    @Override
    public Result detectChange(APIVersion version1, APIVersion version2, Repository repository, RevCommit revCommit) {
        Result result = new Result();
        Map<RefactoringType, List<SDRefactoring>> refactorings = this.detectRefactoring(repository, revCommit.getId().getName());
        result.getChangeType().addAll(new TypeDiff().detectChange(version1, version2, refactorings, revCommit));
        result.getChangeMethod().addAll(new MethodDiff().detectChange(version1, version2, refactorings, revCommit));
        result.getChangeField().addAll(new FieldDiff().detectChange(version1, version2, refactorings, revCommit));
        return result;
    }

    @Override
    public Map<RefactoringType, List<SDRefactoring>> detectRefactoring(Repository repository, String commit) {
        RefactoringProcessorImpl refactoringDetector = new RefactoringProcessorImpl();
        return refactoringDetector.detectRefactoringAtCommit(repository, commit);
    }
}

