/*
 * Decompiled with CFR 0.152.
 */
package apidiff.internal.analysis;

import apidiff.Change;
import apidiff.enums.Category;
import apidiff.internal.analysis.description.FieldDescription;
import apidiff.internal.util.UtilTools;
import apidiff.internal.visitor.APIVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import refdiff.core.api.RefactoringType;
import refdiff.core.rm2.model.refactoring.SDRefactoring;

public class FieldDiff {
    private Logger logger = LoggerFactory.getLogger(FieldDiff.class);
    private Map<RefactoringType, List<SDRefactoring>> refactorings = new HashMap<RefactoringType, List<SDRefactoring>>();
    private List<String> fieldWithPathChanged = new ArrayList<String>();
    private List<Change> listChange = new ArrayList<Change>();
    private FieldDescription description = new FieldDescription();
    private RevCommit revCommit;

    public List<Change> detectChange(APIVersion version1, APIVersion version2, Map<RefactoringType, List<SDRefactoring>> refactorings, RevCommit revCommit) {
        this.logger.info("Processing Filds...");
        this.refactorings = refactorings;
        this.revCommit = revCommit;
        this.findDefaultValueFields(version1, version2);
        this.findChangedTypeFields(version1, version2);
        this.findRemoveAndRefactoringFields(version1, version2);
        this.findChangedVisibilityFields(version1, version2);
        this.findChangedFinal(version1, version2);
        this.findAddedFields(version1, version2);
        this.findAddedDeprecatedFields(version1, version2);
        return this.listChange;
    }

    private void addChange(TypeDeclaration type, FieldDeclaration field, Category category, Boolean isBreakingChange, String description) {
        String name = UtilTools.getFieldName(field);
        if (name != null) {
            Change change = new Change();
            change.setJavadoc(UtilTools.containsJavadoc((AbstractTypeDeclaration)type, field));
            change.setDeprecated(this.isDeprecated(field, (AbstractTypeDeclaration)type));
            change.setBreakingChange(this.isDeprecated(field, (AbstractTypeDeclaration)type) != false ? false : isBreakingChange);
            change.setPath(UtilTools.getPath((AbstractTypeDeclaration)type));
            change.setElement(name);
            change.setCategory(category);
            change.setDescription(description);
            change.setRevCommit(this.revCommit);
            isBreakingChange = this.isDeprecated(field, (AbstractTypeDeclaration)type) != false ? false : isBreakingChange;
            this.listChange.add(change);
        } else {
            this.logger.error("Removing field with null name " + field);
        }
    }

    private List<SDRefactoring> getAllMoveOperations() {
        ArrayList<SDRefactoring> listMove = new ArrayList<SDRefactoring>();
        if (this.refactorings.containsKey(RefactoringType.PULL_UP_ATTRIBUTE)) {
            listMove.addAll((Collection)this.refactorings.get(RefactoringType.PULL_UP_ATTRIBUTE));
        }
        if (this.refactorings.containsKey(RefactoringType.PUSH_DOWN_ATTRIBUTE)) {
            listMove.addAll((Collection)this.refactorings.get(RefactoringType.PUSH_DOWN_ATTRIBUTE));
        }
        if (this.refactorings.containsKey(RefactoringType.MOVE_ATTRIBUTE)) {
            listMove.addAll((Collection<SDRefactoring>)this.refactorings.get(RefactoringType.MOVE_ATTRIBUTE));
        }
        return listMove;
    }

    private Category getCategory(RefactoringType refactoringType) {
        switch (refactoringType) {
            case PULL_UP_ATTRIBUTE: {
                return Category.FIELD_PULL_UP;
            }
            case PUSH_DOWN_ATTRIBUTE: {
                return Category.FIELD_PUSH_DOWN;
            }
        }
        return Category.FIELD_MOVE;
    }

    private Boolean processMoveField(FieldDeclaration field, TypeDeclaration type) {
        List<SDRefactoring> listMove = this.getAllMoveOperations();
        if (listMove != null) {
            for (SDRefactoring ref : listMove) {
                String fullNameAndPath = this.getNameAndPath(field, type);
                if (!fullNameAndPath.equals(ref.getEntityBefore().fullName())) continue;
                Boolean isBreakingChange = !RefactoringType.PULL_UP_OPERATION.equals((Object)ref.getRefactoringType());
                Category category = this.getCategory(ref.getRefactoringType());
                String description = this.description.refactorField(category, ref);
                this.addChange(type, field, category, isBreakingChange, description);
                this.fieldWithPathChanged.add(ref.getEntityAfter().fullName());
                return true;
            }
        }
        return false;
    }

    private String getNameAndPath(FieldDeclaration field, TypeDeclaration type) {
        return UtilTools.getPath((AbstractTypeDeclaration)type) + "#" + UtilTools.getFieldName(field);
    }

    private Boolean processRemoveField(FieldDeclaration field, TypeDeclaration type) {
        String description = this.description.remove(UtilTools.getFieldName(field), UtilTools.getPath((AbstractTypeDeclaration)type));
        this.addChange(type, field, Category.FIELD_REMOVE, true, description);
        return false;
    }

    private Boolean checkAndProcessRefactoring(FieldDeclaration field, TypeDeclaration type) {
        return this.processMoveField(field, type);
    }

    private Boolean thereAreDifferentDefaultValueField(FieldDeclaration fieldInVersion1, FieldDeclaration fieldInVersion2) {
        List variable1Fragments = fieldInVersion1.fragments();
        List variable2Fragments = fieldInVersion2.fragments();
        Expression valueVersion1 = ((VariableDeclarationFragment)variable1Fragments.get(0)).getInitializer();
        Expression valueVersion2 = ((VariableDeclarationFragment)variable2Fragments.get(0)).getInitializer();
        if (valueVersion1 == null && valueVersion2 != null || valueVersion1 != null && valueVersion2 == null) {
            return true;
        }
        if (valueVersion1 != null && valueVersion2 != null && !valueVersion1.toString().equals(valueVersion2.toString())) {
            return true;
        }
        return false;
    }

    private void findDefaultValueFields(APIVersion version1, APIVersion version2) {
        for (TypeDeclaration type : version1.getApiAcessibleTypes()) {
            if (!version2.containsAccessibleType((AbstractTypeDeclaration)type)) continue;
            for (FieldDeclaration fieldInVersion1 : type.getFields()) {
                FieldDeclaration fieldInVersion2;
                if (!this.isFildAcessible(fieldInVersion1) || !this.isFildAcessible(fieldInVersion2 = version2.getVersionField(fieldInVersion1, type)) || !this.thereAreDifferentDefaultValueField(fieldInVersion1, fieldInVersion2).booleanValue()) continue;
                String description = this.description.changeDefaultValue(UtilTools.getFieldName(fieldInVersion2), UtilTools.getPath((AbstractTypeDeclaration)type));
                this.addChange(type, fieldInVersion2, Category.FIELD_CHANGE_DEFAULT_VALUE, true, description);
            }
        }
    }

    private void findChangedTypeFields(APIVersion version1, APIVersion version2) {
        for (TypeDeclaration type : version1.getApiAcessibleTypes()) {
            if (!version2.containsAccessibleType((AbstractTypeDeclaration)type)) continue;
            for (FieldDeclaration fieldInVersion1 : type.getFields()) {
                FieldDeclaration fieldInVersion2;
                if (UtilTools.isVisibilityPrivate((BodyDeclaration)fieldInVersion1) || UtilTools.isVisibilityDefault((BodyDeclaration)fieldInVersion1) || (fieldInVersion2 = version2.getVersionField(fieldInVersion1, type)) == null || UtilTools.isVisibilityPrivate((BodyDeclaration)fieldInVersion2) || fieldInVersion1.getType().toString().equals(fieldInVersion2.getType().toString())) continue;
                String description = this.description.returnType(UtilTools.getFieldName(fieldInVersion2), UtilTools.getPath((AbstractTypeDeclaration)type));
                this.addChange(type, fieldInVersion2, Category.FIELD_CHANGE_TYPE, true, description);
            }
        }
    }

    private void checkGainOrLostVisibility(TypeDeclaration typeVersion1, FieldDeclaration fieldVersion1, FieldDeclaration fieldVersion2) {
        String visibilityMethod2;
        String visibilityMethod1;
        if (fieldVersion2 != null && fieldVersion1 != null && !(visibilityMethod1 = UtilTools.getVisibility((BodyDeclaration)fieldVersion1)).equals(visibilityMethod2 = UtilTools.getVisibility((BodyDeclaration)fieldVersion2))) {
            String description = this.description.visibility(UtilTools.getFieldName(fieldVersion1), UtilTools.getPath((AbstractTypeDeclaration)typeVersion1), visibilityMethod1, visibilityMethod2);
            if (this.isFildAcessible(fieldVersion1) && !UtilTools.isVisibilityPublic((BodyDeclaration)fieldVersion2)) {
                this.addChange(typeVersion1, fieldVersion1, Category.FIELD_LOST_VISIBILITY, true, description);
            } else {
                Category category = UtilTools.isVisibilityDefault((BodyDeclaration)fieldVersion1) && UtilTools.isVisibilityPrivate((BodyDeclaration)fieldVersion2) ? Category.FIELD_LOST_VISIBILITY : Category.FIELD_GAIN_VISIBILITY;
                this.addChange(typeVersion1, fieldVersion1, category, false, description);
            }
        }
    }

    private void findChangedVisibilityFields(APIVersion version1, APIVersion version2) {
        for (TypeDeclaration typeVersion1 : version1.getApiAcessibleTypes()) {
            if (!version2.containsAccessibleType((AbstractTypeDeclaration)typeVersion1)) continue;
            for (FieldDeclaration fieldVersion1 : typeVersion1.getFields()) {
                FieldDeclaration fieldVersion2 = version2.getVersionField(fieldVersion1, typeVersion1);
                this.checkGainOrLostVisibility(typeVersion1, fieldVersion1, fieldVersion2);
            }
        }
    }

    private void findAddedDeprecatedFields(APIVersion version1, APIVersion version2) {
        for (TypeDeclaration typeVersion2 : version2.getApiAcessibleTypes()) {
            for (FieldDeclaration fieldVersion2 : typeVersion2.getFields()) {
                FieldDeclaration fieldInVersion1;
                if (!this.isFildAcessible(fieldVersion2) || !this.isDeprecated(fieldVersion2, (AbstractTypeDeclaration)typeVersion2).booleanValue() || (fieldInVersion1 = version1.getVersionField(fieldVersion2, typeVersion2)) != null && this.isDeprecated(fieldInVersion1, version1.getVersionAccessibleType((AbstractTypeDeclaration)typeVersion2)).booleanValue()) continue;
                String description = this.description.deprecate(UtilTools.getFieldName(fieldVersion2), UtilTools.getPath((AbstractTypeDeclaration)typeVersion2));
                this.addChange(typeVersion2, fieldVersion2, Category.FIELD_DEPRECATED, false, description);
            }
        }
    }

    private void findAddedFields(APIVersion version1, APIVersion version2) {
        for (TypeDeclaration typeVersion2 : version2.getApiAcessibleTypes()) {
            if (!version1.containsAccessibleType((AbstractTypeDeclaration)typeVersion2)) continue;
            for (FieldDeclaration fieldInVersion2 : typeVersion2.getFields()) {
                FieldDeclaration fieldInVersion1;
                String fullNameAndPath = this.getNameAndPath(fieldInVersion2, typeVersion2);
                if (UtilTools.isVisibilityPrivate((BodyDeclaration)fieldInVersion2) || UtilTools.isVisibilityDefault((BodyDeclaration)fieldInVersion2) || this.fieldWithPathChanged.contains(fullNameAndPath) || (fieldInVersion1 = version1.getVersionField(fieldInVersion2, typeVersion2)) != null) continue;
                String description = this.description.addition(UtilTools.getFieldName(fieldInVersion2), UtilTools.getPath((AbstractTypeDeclaration)typeVersion2));
                this.addChange(typeVersion2, fieldInVersion2, Category.FIELD_ADD, false, description);
            }
        }
    }

    private void findRemoveAndRefactoringFields(APIVersion version1, APIVersion version2) {
        for (TypeDeclaration type : version1.getApiAcessibleTypes()) {
            if (!version2.containsAccessibleType((AbstractTypeDeclaration)type)) continue;
            for (FieldDeclaration fieldInVersion1 : type.getFields()) {
                Boolean refactoring;
                FieldDeclaration fieldInVersion2;
                if (UtilTools.isVisibilityPrivate((BodyDeclaration)fieldInVersion1) || (fieldInVersion2 = version2.getVersionField(fieldInVersion1, type)) != null || (refactoring = this.checkAndProcessRefactoring(fieldInVersion1, type)).booleanValue()) continue;
                this.processRemoveField(fieldInVersion1, type);
            }
        }
    }

    private Boolean isDeprecated(FieldDeclaration field, AbstractTypeDeclaration type) {
        Boolean isFildDeprecated = this.isDeprecatedField(field);
        Boolean isTypeDeprecated = type != null && type.resolveBinding() != null && type.resolveBinding().isDeprecated();
        return isFildDeprecated != false || isTypeDeprecated != false;
    }

    private Boolean isDeprecatedField(FieldDeclaration field) {
        if (field != null) {
            List variableFragments = field.fragments();
            for (VariableDeclarationFragment variableDeclarationFragment : variableFragments) {
                if (variableDeclarationFragment.resolveBinding() == null || !variableDeclarationFragment.resolveBinding().isDeprecated()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFildAcessible(FieldDeclaration field) {
        return field != null && (UtilTools.isVisibilityProtected((BodyDeclaration)field) || UtilTools.isVisibilityPublic((BodyDeclaration)field));
    }

    private void diffModifierFinal(TypeDeclaration typeVersion1, FieldDeclaration fieldVersion1, FieldDeclaration fieldVersion2) {
        if (UtilTools.isFinal((BodyDeclaration)fieldVersion1).booleanValue() && UtilTools.isFinal((BodyDeclaration)fieldVersion2).booleanValue() || !UtilTools.isFinal((BodyDeclaration)fieldVersion1).booleanValue() && !UtilTools.isFinal((BodyDeclaration)fieldVersion2).booleanValue()) {
            return;
        }
        String description = "";
        if (!UtilTools.isFinal((BodyDeclaration)fieldVersion1).booleanValue() && UtilTools.isFinal((BodyDeclaration)fieldVersion2).booleanValue()) {
            description = this.description.modifierFinal(UtilTools.getFieldName(fieldVersion2), UtilTools.getPath((AbstractTypeDeclaration)typeVersion1), true);
            this.addChange(typeVersion1, fieldVersion2, Category.FIELD_ADD_MODIFIER_FINAL, true, description);
        } else {
            description = this.description.modifierFinal(UtilTools.getFieldName(fieldVersion2), UtilTools.getPath((AbstractTypeDeclaration)typeVersion1), false);
            this.addChange(typeVersion1, fieldVersion2, Category.FIELD_REMOVE_MODIFIER_FINAL, false, description);
        }
    }

    private void findChangedFinal(APIVersion version1, APIVersion version2) {
        for (TypeDeclaration typeInVersion1 : version1.getApiAcessibleTypes()) {
            if (!version2.containsType(typeInVersion1)) continue;
            for (FieldDeclaration fieldVersion1 : typeInVersion1.getFields()) {
                FieldDeclaration fieldVersion2 = version2.getVersionField(fieldVersion1, typeInVersion1);
                if (!this.isFildAcessible(fieldVersion1) || fieldVersion2 == null) continue;
                this.diffModifierFinal(typeInVersion1, fieldVersion1, fieldVersion2);
            }
        }
    }
}

