/*
 * Decompiled with CFR 0.152.
 */
package apidiff.internal.analysis;

import apidiff.Change;
import apidiff.enums.Category;
import apidiff.internal.analysis.description.TypeDescription;
import apidiff.internal.util.UtilTools;
import apidiff.internal.visitor.APIVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import refdiff.core.api.RefactoringType;
import refdiff.core.rm2.model.refactoring.SDRefactoring;

public class TypeDiff {
    private List<Change> listChange = new ArrayList<Change>();
    private Logger logger = LoggerFactory.getLogger(TypeDiff.class);
    private TypeDescription description = new TypeDescription();
    private APIVersion version1;
    private APIVersion version2;
    private Map<RefactoringType, List<SDRefactoring>> refactorings = new HashMap<RefactoringType, List<SDRefactoring>>();
    private List<String> typesWithPathChanged = new ArrayList<String>();
    private RevCommit revCommit;

    public List<Change> detectChange(APIVersion version1, APIVersion version2, Map<RefactoringType, List<SDRefactoring>> refactorings, RevCommit revCommit) {
        this.version1 = version1;
        this.version2 = version2;
        this.revCommit = revCommit;
        this.refactorings = refactorings;
        this.logger.info("Processing Types ...");
        this.findRemovedAndRenameAndMoveTypes();
        this.findAddedTypes();
        this.findChangedVisibilityTypes();
        this.findAddTypeDeprecate();
        this.findChangedSuperTypes();
        this.findChangedFinalAndStatic();
        return this.listChange;
    }

    private void addChange(AbstractTypeDeclaration type, Category category, Boolean isBreakingChange, String description) {
        Change change = new Change();
        change.setJavadoc(UtilTools.containsJavadoc(type));
        change.setDeprecated(this.isDeprecated(type));
        change.setBreakingChange(this.isDeprecated(type) != false ? false : isBreakingChange);
        change.setPath(UtilTools.getPath(type));
        change.setElement(type.getName().toString());
        change.setCategory(category);
        change.setDescription(description);
        change.setRevCommit(this.revCommit);
        this.listChange.add(change);
    }

    private Boolean processRenameType(AbstractTypeDeclaration type) {
        List<SDRefactoring> listRenames = this.refactorings.get(RefactoringType.RENAME_CLASS);
        if (listRenames != null) {
            for (SDRefactoring ref : listRenames) {
                if (!UtilTools.getPath(type).equals(ref.getEntityBefore().fullName())) continue;
                String description = this.description.rename(ref.getEntityBefore().fullName(), ref.getEntityAfter().fullName());
                this.typesWithPathChanged.add(ref.getEntityAfter().fullName());
                this.addChange(type, Category.TYPE_RENAME, true, description);
                return true;
            }
        }
        return false;
    }

    private Boolean processMoveType(AbstractTypeDeclaration type) {
        List<SDRefactoring> listRenames = this.refactorings.get(RefactoringType.MOVE_CLASS);
        if (listRenames != null) {
            for (SDRefactoring ref : listRenames) {
                if (!UtilTools.getPath(type).equals(ref.getEntityBefore().fullName())) continue;
                String description = this.description.move(ref.getEntityBefore().fullName(), ref.getEntityAfter().fullName());
                this.typesWithPathChanged.add(ref.getEntityAfter().fullName());
                this.addChange(type, Category.TYPE_MOVE, true, description);
                return true;
            }
        }
        return false;
    }

    private Boolean processMoveAndRenameType(AbstractTypeDeclaration type) {
        List<SDRefactoring> listRenames = this.refactorings.get(RefactoringType.MOVE_RENAME_CLASS);
        if (listRenames != null) {
            for (SDRefactoring ref : listRenames) {
                if (!UtilTools.getPath(type).equals(ref.getEntityBefore().fullName())) continue;
                String description = this.description.moveAndRename(ref.getEntityBefore().fullName(), ref.getEntityAfter().fullName());
                this.typesWithPathChanged.add(ref.getEntityAfter().fullName());
                this.addChange(type, Category.TYPE_MOVE_AND_RENAME, true, description);
                return true;
            }
        }
        return false;
    }

    private Boolean processExtractSuperType(AbstractTypeDeclaration type) {
        ArrayList listRenames = new ArrayList();
        if (this.refactorings.containsKey(RefactoringType.EXTRACT_SUPERCLASS)) {
            listRenames.addAll(this.refactorings.get(RefactoringType.EXTRACT_SUPERCLASS));
        }
        if (this.refactorings.containsKey(RefactoringType.EXTRACT_INTERFACE)) {
            listRenames.addAll(this.refactorings.get(RefactoringType.EXTRACT_INTERFACE));
        }
        if (listRenames != null) {
            for (SDRefactoring ref : listRenames) {
                if (!UtilTools.getPath(type).equals(ref.getEntityBefore().fullName())) continue;
                this.typesWithPathChanged.add(ref.getEntityAfter().fullName());
                this.addChange(type, Category.TYPE_EXTRACT_SUPERTYPE, false, "");
                return true;
            }
        }
        return false;
    }

    protected void processRemoveType(AbstractTypeDeclaration type) {
        String description = this.description.remove(UtilTools.getPath(type));
        this.addChange(type, Category.TYPE_REMOVE, true, description);
    }

    protected Boolean checkAndProcessRefactoring(AbstractTypeDeclaration type) {
        Boolean rename = this.processRenameType(type);
        Boolean move = this.processMoveType(type);
        Boolean moveAndRename = this.processMoveAndRenameType(type);
        Boolean extract = this.processExtractSuperType(type);
        return rename != false || move != false || moveAndRename != false || extract != false;
    }

    private void findChangedSuperTypes() {
        for (AbstractTypeDeclaration accessibleTypeVersion1 : this.version1.getTypesPublicAndProtected()) {
            AbstractTypeDeclaration accessibleTypeVersion2 = this.version2.getVersionAccessibleType(accessibleTypeVersion1);
            if (accessibleTypeVersion2 == null) continue;
            String super1 = this.getNameSuperClass(accessibleTypeVersion1);
            String super2 = this.getNameSuperClass(accessibleTypeVersion2);
            if (super1 == null || super2 == null) continue;
            Boolean isBreakingChange = true;
            String nameClassComplete = UtilTools.getPath(accessibleTypeVersion2);
            String description = "";
            if (this.containsSuperClass(accessibleTypeVersion1) && !this.containsSuperClass(accessibleTypeVersion2)) {
                description = this.description.changeSuperType(nameClassComplete, super1, "");
                this.addChange(accessibleTypeVersion2, Category.TYPE_REMOVE_SUPERCLASS, isBreakingChange, description);
            }
            if (!this.containsSuperClass(accessibleTypeVersion1) && this.containsSuperClass(accessibleTypeVersion2)) {
                description = this.description.changeSuperType(nameClassComplete, "", super2);
                this.addChange(accessibleTypeVersion2, Category.TYPE_ADD_SUPER_CLASS, false, description);
            }
            if (!this.containsSuperClass(accessibleTypeVersion1) || !this.containsSuperClass(accessibleTypeVersion2) || super1.equals(super2)) continue;
            description = this.description.changeSuperType(nameClassComplete, super1, super2);
            this.addChange(accessibleTypeVersion2, Category.TYPE_CHANGE_SUPERCLASS, false, description);
        }
    }

    private void findAddTypeDeprecate() {
        for (AbstractTypeDeclaration accessibleTypeVersion1 : this.version1.getTypesPublicAndProtected()) {
            AbstractTypeDeclaration accessibleTypeVersion2 = this.version2.getVersionAccessibleType(accessibleTypeVersion1);
            if (accessibleTypeVersion2 == null || this.isDeprecated(accessibleTypeVersion1).booleanValue() || !this.isDeprecated(accessibleTypeVersion2).booleanValue()) continue;
            String description = this.description.deprecate(UtilTools.getPath(accessibleTypeVersion2));
            this.addChange(accessibleTypeVersion1, Category.TYPE_DEPRECATED, false, description);
        }
    }

    private AbstractTypeDeclaration findTypeDeclarationInList(List<AbstractTypeDeclaration> list, AbstractTypeDeclaration type) {
        for (int i = 0; i < list.size(); ++i) {
            AbstractTypeDeclaration typeDeclaration = list.get(i);
            if (!UtilTools.getPath(type).equals(UtilTools.getPath(typeDeclaration))) continue;
            return typeDeclaration;
        }
        return null;
    }

    private void findChangedVisibilityTypes() {
        List<AbstractTypeDeclaration> listTypesVersion1 = this.version1.getAllTypes();
        List<AbstractTypeDeclaration> listTypesVersion2 = this.version2.getAllTypes();
        for (AbstractTypeDeclaration type1 : listTypesVersion1) {
            String visibilityType2;
            String visibilityType1;
            AbstractTypeDeclaration type2 = this.findTypeDeclarationInList(listTypesVersion2, type1);
            if (type2 == null || (visibilityType1 = UtilTools.getVisibility((BodyDeclaration)type1)).equals(visibilityType2 = UtilTools.getVisibility((BodyDeclaration)type2))) continue;
            String description = this.description.visibility(UtilTools.getPath(type2), visibilityType1, visibilityType2);
            if (UtilTools.isVisibilityPublic((BodyDeclaration)type1) || UtilTools.isVisibilityProtected((BodyDeclaration)type1) && !UtilTools.isVisibilityPublic((BodyDeclaration)type2)) {
                this.addChange(type2, Category.TYPE_LOST_VISIBILITY, true, description);
                continue;
            }
            Category category = UtilTools.isVisibilityDefault((BodyDeclaration)type1) && UtilTools.isVisibilityPrivate((BodyDeclaration)type2) ? Category.TYPE_LOST_VISIBILITY : Category.TYPE_GAIN_VISIBILITY;
            this.addChange(type2, category, false, description);
        }
    }

    private void findAddedTypes() {
        List<AbstractTypeDeclaration> listTypesVersion2 = UtilTools.getAcessibleTypes(this.version2);
        for (AbstractTypeDeclaration typeVersion2 : listTypesVersion2) {
            if (this.version1.containsAccessibleType(typeVersion2) || this.version1.containsNonAccessibleType(typeVersion2) || this.typesWithPathChanged.contains(UtilTools.getPath(typeVersion2))) continue;
            String description = this.description.addition(UtilTools.getPath(typeVersion2));
            this.addChange(typeVersion2, Category.TYPE_ADD, false, description);
        }
    }

    private void findRemovedAndRenameAndMoveTypes() {
        for (AbstractTypeDeclaration type : this.version1.getTypesPublicAndProtected()) {
            Boolean refactoring;
            if (this.version2.containsAccessibleType(type) || this.version2.containsNonAccessibleType(type) || (refactoring = this.checkAndProcessRefactoring(type)).booleanValue()) continue;
            this.processRemoveType(type);
        }
    }

    private Boolean isDeprecated(AbstractTypeDeclaration type) {
        return type != null && type.resolveBinding() != null && type.resolveBinding().isDeprecated();
    }

    private String getNameSuperClass(AbstractTypeDeclaration type) {
        if (type.resolveBinding() != null && type.resolveBinding().getSuperclass() != null) {
            return type.resolveBinding().getSuperclass().getQualifiedName().toString();
        }
        return null;
    }

    private boolean containsSuperClass(AbstractTypeDeclaration type) {
        String nameSuperClass = this.getNameSuperClass(type);
        return nameSuperClass != null && !"java.lang.Object".equals(nameSuperClass);
    }

    private void diffModifierFinal(AbstractTypeDeclaration typeVersion1, AbstractTypeDeclaration typeVersion2) {
        if (UtilTools.isFinal((BodyDeclaration)typeVersion1).booleanValue() && UtilTools.isFinal((BodyDeclaration)typeVersion2).booleanValue() || !UtilTools.isFinal((BodyDeclaration)typeVersion1).booleanValue() && !UtilTools.isFinal((BodyDeclaration)typeVersion2).booleanValue()) {
            return;
        }
        if (!UtilTools.isFinal((BodyDeclaration)typeVersion1).booleanValue() && UtilTools.isFinal((BodyDeclaration)typeVersion2).booleanValue()) {
            String description = this.description.modifierFinal(UtilTools.getPath(typeVersion2), true);
            this.addChange(typeVersion2, Category.TYPE_ADD_MODIFIER_FINAL, true, description);
        } else {
            String description = this.description.modifierFinal(UtilTools.getPath(typeVersion2), false);
            this.addChange(typeVersion2, Category.TYPE_REMOVE_MODIFIER_FINAL, false, description);
        }
    }

    private void diffModifierStatic(AbstractTypeDeclaration typeVersion1, AbstractTypeDeclaration typeVersion2) {
        if (UtilTools.isStatic((BodyDeclaration)typeVersion1).booleanValue() && UtilTools.isStatic((BodyDeclaration)typeVersion2).booleanValue() || !UtilTools.isStatic((BodyDeclaration)typeVersion1).booleanValue() && !UtilTools.isStatic((BodyDeclaration)typeVersion2).booleanValue()) {
            return;
        }
        if (!UtilTools.isStatic((BodyDeclaration)typeVersion1).booleanValue() && UtilTools.isStatic((BodyDeclaration)typeVersion2).booleanValue()) {
            String description = this.description.modifierStatic(UtilTools.getPath(typeVersion2), true);
            this.addChange(typeVersion2, Category.TYPE_ADD_MODIFIER_STATIC, false, description);
        } else {
            String description = this.description.modifierStatic(UtilTools.getPath(typeVersion2), false);
            this.addChange(typeVersion2, Category.TYPE_REMOVE_MODIFIER_STATIC, true, description);
        }
    }

    private void findChangedFinalAndStatic() {
        for (AbstractTypeDeclaration typeVersion1 : this.version1.getTypesPublicAndProtected()) {
            AbstractTypeDeclaration typeVersion2 = this.version2.getVersionAccessibleType(typeVersion1);
            if (typeVersion2 == null) continue;
            this.diffModifierFinal(typeVersion1, typeVersion2);
            this.diffModifierStatic(typeVersion1, typeVersion2);
        }
    }

    private String getSimpleNameClass(AbstractTypeDeclaration typeVersion) {
        return typeVersion.getName().toString();
    }

    private String getNamePackage(AbstractTypeDeclaration typeVersion) {
        String simpleName = this.getSimpleNameClass(typeVersion);
        String nameComplete = UtilTools.getPath(typeVersion);
        nameComplete = nameComplete.replaceAll("." + simpleName, "");
        return nameComplete;
    }
}

