/*
 * Decompiled with CFR 0.152.
 */
package apidiff.internal.service.git;

import apidiff.internal.service.git.GitFile;
import apidiff.internal.service.git.GitService;
import apidiff.internal.util.UtilTools;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitServiceImpl
implements GitService {
    private static final String REMOTE_REFS_PREFIX = "refs/remotes/origin/";
    private RevFilterCommitValid commitsFilter = new RevFilterCommitValid();
    private Logger logger = LoggerFactory.getLogger(GitServiceImpl.class);
    private static final Long MINUTE = 60000L;
    private static final Long HOUR = MINUTE * 60L;
    private static final Long DAY = HOUR * 24L;
    private static final Long SEVEN_DAYS = DAY * 7L;

    @Override
    public Repository openRepositoryAndCloneIfNotExists(String path, String projectName, String cloneUrl) throws Exception {
        File folder = new File(UtilTools.getPathProject(path, projectName));
        Repository repository = null;
        if (folder.exists()) {
            this.logger.info(projectName + " exists. Reading properties ... (wait)");
            RepositoryBuilder builder = new RepositoryBuilder();
            repository = ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)builder.setGitDir(new File(folder, ".git"))).readEnvironment()).findGitDir()).build();
        } else {
            this.logger.info("Cloning " + cloneUrl + " in " + cloneUrl + " ... (wait)");
            Git git = Git.cloneRepository().setDirectory(folder).setURI(cloneUrl).setCloneAllBranches(true).call();
            repository = git.getRepository();
        }
        this.logger.info("Process " + projectName + " finish.");
        return repository;
    }

    @Override
    public RevWalk fetchAndCreateNewRevsWalk(Repository repository, String branch) throws Exception {
        ArrayList<ObjectId> currentRemoteRefs = new ArrayList<ObjectId>();
        for (Ref ref : repository.getAllRefs().values()) {
            String refName = ref.getName();
            if (!refName.startsWith(REMOTE_REFS_PREFIX)) continue;
            currentRemoteRefs.add(ref.getObjectId());
        }
        List<TrackingRefUpdate> newRemoteRefs = this.fetch(repository);
        RevWalk walk = new RevWalk(repository);
        for (TrackingRefUpdate newRef : newRemoteRefs) {
            if (branch != null && !newRef.getLocalName().endsWith("/" + branch)) continue;
            walk.markStart(walk.parseCommit((AnyObjectId)newRef.getNewObjectId()));
        }
        for (ObjectId oldRef : currentRemoteRefs) {
            walk.markUninteresting(walk.parseCommit((AnyObjectId)oldRef));
        }
        walk.setRevFilter((RevFilter)this.commitsFilter);
        return walk;
    }

    @Override
    public RevWalk createAllRevsWalk(Repository repository, String branch) throws Exception {
        ArrayList<ObjectId> currentRemoteRefs = new ArrayList<ObjectId>();
        for (Ref ref : repository.getAllRefs().values()) {
            String refName = ref.getName();
            if (!refName.startsWith(REMOTE_REFS_PREFIX) || branch != null && !refName.endsWith("/" + branch)) continue;
            currentRemoteRefs.add(ref.getObjectId());
        }
        RevWalk walk = new RevWalk(repository);
        for (ObjectId newRef : currentRemoteRefs) {
            walk.markStart(walk.parseCommit((AnyObjectId)newRef));
        }
        walk.setRevFilter((RevFilter)this.commitsFilter);
        return walk;
    }

    private List<TrackingRefUpdate> fetch(Repository repository) throws Exception {
        this.logger.info("Fetching changes of repository " + repository.getDirectory().toString());
        try (Git git = new Git(repository);){
            FetchResult result = git.fetch().call();
            Collection updates = result.getTrackingRefUpdates();
            ArrayList<TrackingRefUpdate> remoteRefsChanges = new ArrayList<TrackingRefUpdate>();
            for (TrackingRefUpdate update : updates) {
                String refName = update.getLocalName();
                if (!refName.startsWith(REMOTE_REFS_PREFIX)) continue;
                ObjectId newObjectId = update.getNewObjectId();
                this.logger.info(refName + " is now at " + newObjectId.getName());
                remoteRefsChanges.add(update);
            }
            if (updates.isEmpty()) {
                this.logger.info("Nothing changed");
            }
            ArrayList<TrackingRefUpdate> arrayList = remoteRefsChanges;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer countCommits(Repository repository, String branch) throws Exception {
        RevWalk walk = new RevWalk(repository);
        try {
            Ref ref = repository.findRef(REMOTE_REFS_PREFIX + branch);
            ObjectId objectId = ref.getObjectId();
            RevCommit start = walk.parseCommit((AnyObjectId)objectId);
            walk.setRevFilter(RevFilter.NO_MERGES);
            Integer n = RevWalkUtils.count((RevWalk)walk, (RevCommit)start, null);
            return n;
        }
        finally {
            walk.dispose();
        }
    }

    @Override
    public Map<DiffEntry.ChangeType, List<GitFile>> fileTreeDiff(Repository repository, RevCommit commitNew) throws Exception {
        HashMap<DiffEntry.ChangeType, List<GitFile>> mapDiff = new HashMap<DiffEntry.ChangeType, List<GitFile>>();
        mapDiff.put(DiffEntry.ChangeType.ADD, new ArrayList());
        mapDiff.put(DiffEntry.ChangeType.COPY, new ArrayList());
        mapDiff.put(DiffEntry.ChangeType.DELETE, new ArrayList());
        mapDiff.put(DiffEntry.ChangeType.MODIFY, new ArrayList());
        mapDiff.put(DiffEntry.ChangeType.RENAME, new ArrayList());
        if (commitNew.getParentCount() == 0) {
            this.logger.warn("Commit don't have parent [commitId=" + commitNew.getId().getName() + "]");
            return mapDiff;
        }
        RevTree headOld = commitNew.getParent(0).getTree();
        RevTree headNew = commitNew.getTree();
        ObjectReader reader = repository.newObjectReader();
        CanonicalTreeParser treeRepositoryOld = new CanonicalTreeParser();
        treeRepositoryOld.reset(reader, (AnyObjectId)headOld);
        CanonicalTreeParser treeRepositoryNew = new CanonicalTreeParser();
        treeRepositoryNew.reset(reader, (AnyObjectId)headNew);
        List diffs = new Git(repository).diff().setNewTree((AbstractTreeIterator)treeRepositoryNew).setOldTree((AbstractTreeIterator)treeRepositoryOld).setShowNameAndStatusOnly(true).call();
        for (DiffEntry entry : diffs) {
            if (!UtilTools.isJavaFile(entry.getOldPath()).booleanValue() && !UtilTools.isJavaFile(entry.getNewPath()).booleanValue()) continue;
            String pathNew = "/dev/null".equals(entry.getNewPath()) ? null : entry.getNewPath();
            String pathOld = "/dev/null".equals(entry.getOldPath()) ? null : entry.getOldPath();
            GitFile file = new GitFile(pathOld, pathNew, entry.getChangeType());
            ((List)mapDiff.get(entry.getChangeType())).add(file);
        }
        return mapDiff;
    }

    @Override
    public void checkout(Repository repository, String commitId) throws Exception {
        this.logger.info("Checking out {} {} ...", (Object)repository.getDirectory().getParent().toString(), (Object)commitId);
        try (Git git = new Git(repository);){
            CheckoutCommand checkout = git.checkout().setName(commitId);
            checkout.call();
        }
    }

    @Override
    public RevCommit createRevCommitByCommitId(Repository repository, String commitId) throws Exception {
        RevWalk walk = new RevWalk(repository);
        RevCommit commit = walk.parseCommit((AnyObjectId)repository.resolve(commitId));
        walk.parseCommit((AnyObjectId)commit.getParent(0));
        return commit;
    }

    private class RevFilterCommitValid
    extends RevFilter {
        private RevFilterCommitValid() {
        }

        public final boolean include(RevWalk walker, RevCommit c) {
            Long diffTimestamp = 0L;
            diffTimestamp = this.calcDiffTimeCommit(c);
            if (c.getParentCount() > 1) {
                GitServiceImpl.this.logger.info("Merge of the branches deleted. [commitId=" + c.getId().getName() + "]");
                return false;
            }
            return true;
        }

        private Long calcDiffTimeCommit(RevCommit c) {
            Long timestampNow = Calendar.getInstance().getTimeInMillis();
            Long timestampCommit = c.getAuthorIdent().getWhen().getTime();
            Calendar calendarCommit = Calendar.getInstance();
            calendarCommit.setTime(new Date(timestampCommit));
            return Math.abs(timestampCommit - timestampNow);
        }

        private String getDateCommitFormat(RevCommit c) {
            Long timestampCommit = c.getAuthorIdent().getWhen().getTime();
            Calendar calendarCommit = Calendar.getInstance();
            calendarCommit.setTime(new Date(timestampCommit));
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
            return format.format(timestampCommit);
        }

        public final RevFilter clone() {
            return this;
        }

        public final boolean requiresCommitBody() {
            return false;
        }

        public String toString() {
            return "RegularCommitsFilter";
        }
    }
}

