/*
 * Decompiled with CFR 0.152.
 */
package com.github.eventsource.client;

import com.github.eventsource.client.EventSourceChannelHandler;
import com.github.eventsource.client.EventSourceClientHandler;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.string.StringDecoder;

public class EventSource {
    public static final long DEFAULT_RECONNECTION_TIME_MILLIS = 2000L;
    private final ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newSingleThreadExecutor(), (Executor)Executors.newSingleThreadExecutor()));
    private final EventSourceChannelHandler clientHandler;

    public EventSource(Executor executor, long reconnectionTimeMillis, URI uri, EventSourceClientHandler eventSourceHandler) {
        this.bootstrap.setOption("remoteAddress", (Object)new InetSocketAddress(uri.getHost(), uri.getPort()));
        this.clientHandler = new EventSourceChannelHandler(executor, reconnectionTimeMillis, this.bootstrap, uri, eventSourceHandler);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("line", (ChannelHandler)new DelimiterBasedFrameDecoder(Integer.MAX_VALUE, Delimiters.lineDelimiter()));
                pipeline.addLast("string", (ChannelHandler)new StringDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
                pipeline.addLast("es-handler", (ChannelHandler)EventSource.this.clientHandler);
                return pipeline;
            }
        });
    }

    public EventSource(URI uri, EventSourceClientHandler eventSourceHandler) {
        this(Executors.newSingleThreadExecutor(), 2000L, uri, eventSourceHandler);
    }

    public ChannelFuture connect() {
        return this.bootstrap.connect();
    }

    public EventSource close() {
        this.clientHandler.close();
        return this;
    }

    public EventSource join() throws InterruptedException {
        this.clientHandler.join();
        return this;
    }
}

