/*
 * Decompiled with CFR 0.152.
 */
package com.github.gorbin.asne.twitter;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.github.gorbin.asne.core.OAuthActivity;
import com.github.gorbin.asne.core.OAuthSocialNetwork;
import com.github.gorbin.asne.core.SocialNetworkAsyncTask;
import com.github.gorbin.asne.core.SocialNetworkException;
import com.github.gorbin.asne.core.listener.OnCheckIsFriendCompleteListener;
import com.github.gorbin.asne.core.listener.OnLoginCompleteListener;
import com.github.gorbin.asne.core.listener.OnPostingCompleteListener;
import com.github.gorbin.asne.core.listener.OnRequestAccessTokenCompleteListener;
import com.github.gorbin.asne.core.listener.OnRequestAddFriendCompleteListener;
import com.github.gorbin.asne.core.listener.OnRequestDetailedSocialPersonCompleteListener;
import com.github.gorbin.asne.core.listener.OnRequestGetFriendsCompleteListener;
import com.github.gorbin.asne.core.listener.OnRequestRemoveFriendCompleteListener;
import com.github.gorbin.asne.core.listener.OnRequestSocialPersonCompleteListener;
import com.github.gorbin.asne.core.listener.OnRequestSocialPersonsCompleteListener;
import com.github.gorbin.asne.core.listener.base.SocialNetworkListener;
import com.github.gorbin.asne.core.persons.SocialPerson;
import com.github.gorbin.asne.twitter.TwitterPerson;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import twitter4j.PagableResponseList;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterSocialNetwork
extends OAuthSocialNetwork {
    public static final int ID = 1;
    private static final String SAVE_STATE_KEY_OAUTH_TOKEN = "TwitterSocialNetwork.SAVE_STATE_KEY_OAUTH_TOKEN";
    private static final String SAVE_STATE_KEY_OAUTH_SECRET = "TwitterSocialNetwork.SAVE_STATE_KEY_OAUTH_SECRET";
    private static final String SAVE_STATE_KEY_USER_ID = "TwitterSocialNetwork.SAVE_STATE_KEY_USER_ID";
    private static final String URL_TWITTER_OAUTH_VERIFIER = "oauth_verifier";
    private static final int REQUEST_AUTH = UUID.randomUUID().hashCode() & 0xFFFF;
    private final String fConsumerKey;
    private final String fConsumerSecret;
    private String fRedirectURL;
    private Twitter mTwitter;
    private RequestToken mRequestToken;

    public TwitterSocialNetwork(Fragment fragment, String consumerKey, String consumerSecret, String redirectURL) {
        super(fragment);
        this.fConsumerKey = consumerKey;
        this.fConsumerSecret = consumerSecret;
        this.fRedirectURL = redirectURL;
        if (TextUtils.isEmpty((CharSequence)this.fConsumerKey) || TextUtils.isEmpty((CharSequence)this.fConsumerSecret)) {
            throw new IllegalArgumentException("consumerKey and consumerSecret are invalid");
        }
        this.initTwitterClient();
    }

    private void initTwitterClient() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setOAuthConsumerKey(this.fConsumerKey);
        builder.setOAuthConsumerSecret(this.fConsumerSecret);
        String accessToken = this.mSharedPreferences.getString(SAVE_STATE_KEY_OAUTH_TOKEN, null);
        String accessTokenSecret = this.mSharedPreferences.getString(SAVE_STATE_KEY_OAUTH_SECRET, null);
        TwitterFactory factory = new TwitterFactory(builder.build());
        this.mTwitter = TextUtils.isEmpty((CharSequence)accessToken) && TextUtils.isEmpty((CharSequence)accessTokenSecret) ? factory.getInstance() : factory.getInstance(new AccessToken(accessToken, accessTokenSecret));
    }

    public boolean isConnected() {
        String accessToken = this.mSharedPreferences.getString(SAVE_STATE_KEY_OAUTH_TOKEN, null);
        String accessTokenSecret = this.mSharedPreferences.getString(SAVE_STATE_KEY_OAUTH_SECRET, null);
        return accessToken != null && accessTokenSecret != null;
    }

    public void requestLogin(OnLoginCompleteListener onLoginCompleteListener) {
        super.requestLogin(onLoginCompleteListener);
        this.executeRequest(new RequestLoginAsyncTask(), null, "SocialNetwork.REQUEST_LOGIN");
    }

    public void logout() {
        this.mSharedPreferences.edit().remove(SAVE_STATE_KEY_OAUTH_TOKEN).remove(SAVE_STATE_KEY_OAUTH_SECRET).remove(SAVE_STATE_KEY_USER_ID).apply();
        this.mTwitter = null;
        this.initTwitterClient();
    }

    public int getID() {
        return 1;
    }

    public com.github.gorbin.asne.core.AccessToken getAccessToken() {
        return new com.github.gorbin.asne.core.AccessToken(this.mSharedPreferences.getString(SAVE_STATE_KEY_OAUTH_TOKEN, null), this.mSharedPreferences.getString(SAVE_STATE_KEY_OAUTH_SECRET, null));
    }

    public void requestAccessToken(OnRequestAccessTokenCompleteListener onRequestAccessTokenCompleteListener) {
        super.requestAccessToken(onRequestAccessTokenCompleteListener);
        ((OnRequestAccessTokenCompleteListener)this.mLocalListeners.get("SocialNetwork.REQUEST_ACCESS_TOKEN")).onRequestAccessTokenComplete(this.getID(), new com.github.gorbin.asne.core.AccessToken(this.mSharedPreferences.getString(SAVE_STATE_KEY_OAUTH_TOKEN, null), this.mSharedPreferences.getString(SAVE_STATE_KEY_OAUTH_SECRET, null)));
    }

    public void requestCurrentPerson(OnRequestSocialPersonCompleteListener onRequestSocialPersonCompleteListener) {
        super.requestCurrentPerson(onRequestSocialPersonCompleteListener);
        this.executeRequest(new RequestGetSocialPersonAsyncTask(), null, "SocialNetwork.REQUEST_GET_CURRENT_PERSON");
    }

    public void requestSocialPerson(String userID, OnRequestSocialPersonCompleteListener onRequestSocialPersonCompleteListener) {
        super.requestSocialPerson(userID, onRequestSocialPersonCompleteListener);
        if (TextUtils.isEmpty((CharSequence)userID)) {
            throw new SocialNetworkException("userID can't be null or empty");
        }
        Bundle args = new Bundle();
        try {
            args.putLong("RequestGetPersonAsyncTask.PARAM_USER_ID", Long.parseLong(userID));
        }
        catch (NumberFormatException e) {
            throw new SocialNetworkException("userID should be long number");
        }
        this.executeRequest(new RequestGetSocialPersonAsyncTask(), args, "SocialNetwork.REQUEST_GET_PERSON");
    }

    public void requestSocialPersons(String[] userID, OnRequestSocialPersonsCompleteListener onRequestSocialPersonsCompleteListener) {
        super.requestSocialPersons(userID, onRequestSocialPersonsCompleteListener);
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(userID));
        int i = 0;
        long[] usersId = new long[users.size()];
        for (String user : users) {
            if (TextUtils.isEmpty((CharSequence)user)) {
                users.remove(user);
                break;
            }
            try {
                usersId[i] = Long.parseLong(user);
            }
            catch (NumberFormatException e) {
                throw new SocialNetworkException("userID should be long number");
            }
            ++i;
        }
        Bundle args = new Bundle();
        args.putLongArray("RequestGetPersonAsyncTask.PARAM_USER_ID", usersId);
        this.executeRequest(new RequestSocialPersonsAsyncTask(), args, "SocialNetwork.REQUEST_GET_PERSON");
    }

    public void requestDetailedSocialPerson(String userId, OnRequestDetailedSocialPersonCompleteListener onRequestDetailedSocialPersonCompleteListener) {
        super.requestDetailedSocialPerson(userId, onRequestDetailedSocialPersonCompleteListener);
        Bundle args = new Bundle();
        if (userId != null) {
            try {
                args.putLong("RequestGetPersonAsyncTask.PARAM_USER_ID", Long.parseLong(userId));
            }
            catch (NumberFormatException e) {
                throw new SocialNetworkException("userID should be long number");
            }
        }
        this.executeRequest(new RequestGetDetailedPersonAsyncTask(), args, "SocialNetwork.REQUEST_GET_DETAIL_PERSON");
    }

    private SocialPerson getSocialPerson(SocialPerson socialPerson, User user) {
        socialPerson.id = Long.toString(user.getId());
        socialPerson.name = user.getName();
        socialPerson.avatarURL = user.getBiggerProfileImageURL();
        socialPerson.profileURL = user.getURL();
        return socialPerson;
    }

    private TwitterPerson getDetailedSocialPerson(TwitterPerson twitterPerson, User user) {
        this.getSocialPerson(twitterPerson, user);
        twitterPerson.createdDate = user.getCreatedAt().getTime();
        twitterPerson.description = user.getDescription();
        twitterPerson.favoritesCount = user.getFavouritesCount();
        twitterPerson.followersCount = user.getFollowersCount();
        twitterPerson.friendsCount = user.getFriendsCount();
        twitterPerson.lang = user.getLang();
        twitterPerson.location = user.getLocation();
        twitterPerson.screenName = user.getScreenName();
        twitterPerson.status = user.getStatus() != null ? user.getStatus().getText() : null;
        twitterPerson.timezone = user.getTimeZone();
        twitterPerson.isTranslator = user.isTranslator();
        twitterPerson.isVerified = user.isVerified();
        return twitterPerson;
    }

    public void requestPostMessage(String message, OnPostingCompleteListener onPostingCompleteListener) {
        super.requestPostMessage(message, onPostingCompleteListener);
        Bundle args = new Bundle();
        args.putString("RequestUpdateStatusAsyncTask.PARAM_MESSAGE", message);
        this.executeRequest(new RequestUpdateStatusAsyncTask(), args, "SocialNetwork.REQUEST_POST_MESSAGE");
    }

    public void requestPostPhoto(File photo, String message, OnPostingCompleteListener onPostingCompleteListener) {
        super.requestPostPhoto(photo, message, onPostingCompleteListener);
        Bundle args = new Bundle();
        args.putString("RequestUpdateStatusAsyncTask.PARAM_MESSAGE", message);
        args.putString("RequestUpdateStatusAsyncTask.PARAM_PHOTO_PATH", photo.getAbsolutePath());
        this.executeRequest(new RequestUpdateStatusAsyncTask(), args, "SocialNetwork.REQUEST_POST_PHOTO");
    }

    public void requestPostLink(Bundle bundle, String message, OnPostingCompleteListener onPostingCompleteListener) {
        super.requestPostLink(bundle, message, onPostingCompleteListener);
        Bundle args = bundle;
        args.putString("RequestUpdateStatusAsyncTask.PARAM_MESSAGE", message);
        this.executeRequest(new RequestUpdateStatusAsyncTask(), args, "SocialNetwork.REQUEST_POST_LINK");
    }

    public void requestPostDialog(Bundle bundle, OnPostingCompleteListener onPostingCompleteListener) {
        throw new SocialNetworkException("requestPostDialog isn't allowed for TwitterSocialNetwork");
    }

    public void requestCheckIsFriend(String userID, OnCheckIsFriendCompleteListener onCheckIsFriendCompleteListener) {
        super.requestCheckIsFriend(userID, onCheckIsFriendCompleteListener);
        Bundle args = new Bundle();
        try {
            args.putLong("PARAM_USER_ID", Long.parseLong(userID));
        }
        catch (NumberFormatException e) {
            throw new SocialNetworkException("userID should be long number");
        }
        this.executeRequest(new RequestCheckIsFriendAsyncTask(), args, "SocialNetwork.REQUEST_CHECK_IS_FRIEND");
    }

    public void requestGetFriends(OnRequestGetFriendsCompleteListener onRequestGetFriendsCompleteListener) {
        super.requestGetFriends(onRequestGetFriendsCompleteListener);
        this.executeRequest(new RequestGetFriendsAsyncTask(), null, "SocialNetwork.REQUEST_GET_FRIENDS");
    }

    public void requestAddFriend(String userID, OnRequestAddFriendCompleteListener onRequestAddFriendCompleteListener) {
        super.requestAddFriend(userID, onRequestAddFriendCompleteListener);
        Bundle args = new Bundle();
        try {
            args.putLong("PARAM_USER_ID", Long.parseLong(userID));
        }
        catch (NumberFormatException e) {
            throw new SocialNetworkException("userID should be long number");
        }
        this.executeRequest(new RequestAddFriendAsyncTask(), args, "SocialNetwork.REQUEST_ADD_FRIEND");
    }

    public void requestRemoveFriend(String userID, OnRequestRemoveFriendCompleteListener onRequestRemoveFriendCompleteListener) {
        super.requestRemoveFriend(userID, onRequestRemoveFriendCompleteListener);
        Bundle args = new Bundle();
        try {
            args.putLong("PARAM_USER_ID", Long.parseLong(userID));
        }
        catch (NumberFormatException e) {
            throw new SocialNetworkException("userID should be long number");
        }
        this.executeRequest(new RequestRemoveFriendAsyncTask(), args, "SocialNetwork.REQUEST_REMOVE_FRIEND");
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Uri uri;
        int sanitizedRequestCode = requestCode % 65536;
        if (sanitizedRequestCode != REQUEST_AUTH) {
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
        Uri uri2 = uri = data != null ? data.getData() : null;
        if (uri != null && uri.toString().startsWith(this.fRedirectURL)) {
            String verifier = uri.getQueryParameter(URL_TWITTER_OAUTH_VERIFIER);
            RequestLogin2AsyncTask requestLogin2AsyncTask = new RequestLogin2AsyncTask();
            this.mRequests.put("SocialNetwork.REQUEST_LOGIN2", requestLogin2AsyncTask);
            Bundle args = new Bundle();
            args.putString("Login2AsyncTask.PARAM_VERIFIER", verifier);
            requestLogin2AsyncTask.execute(new Bundle[]{args});
        } else {
            if (this.mLocalListeners.get("SocialNetwork.REQUEST_LOGIN") != null) {
                ((SocialNetworkListener)this.mLocalListeners.get("SocialNetwork.REQUEST_LOGIN")).onError(this.getID(), "SocialNetwork.REQUEST_LOGIN", "incorrect URI returned: " + uri, null);
                this.mLocalListeners.remove("SocialNetwork.REQUEST_LOGIN");
            }
            this.initTwitterClient();
        }
    }

    public void cancelLoginRequest() {
        super.cancelLoginRequest();
        this.initTwitterClient();
    }

    private class RequestRemoveFriendAsyncTask
    extends SocialNetworkAsyncTask {
        public static final String PARAM_USER_ID = "PARAM_USER_ID";
        public static final String RESULT_REQUESTED_ID = "RESULT_REQUESTED_ID";

        private RequestRemoveFriendAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Bundle args = params[0];
            Bundle result = new Bundle();
            Long userID = args.getLong(PARAM_USER_ID);
            result.putLong(RESULT_REQUESTED_ID, userID.longValue());
            try {
                TwitterSocialNetwork.this.mTwitter.destroyFriendship(userID.longValue());
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_REMOVE_FRIEND", result.getLong(RESULT_REQUESTED_ID))) {
                return;
            }
            ((OnRequestRemoveFriendCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_REMOVE_FRIEND")).onRequestRemoveFriendComplete(TwitterSocialNetwork.this.getID(), "" + result.getLong(RESULT_REQUESTED_ID));
        }
    }

    private class RequestAddFriendAsyncTask
    extends SocialNetworkAsyncTask {
        public static final String PARAM_USER_ID = "PARAM_USER_ID";
        public static final String RESULT_REQUESTED_ID = "RESULT_REQUESTED_ID";

        private RequestAddFriendAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Bundle args = params[0];
            Bundle result = new Bundle();
            Long userID = args.getLong(PARAM_USER_ID);
            result.putLong(RESULT_REQUESTED_ID, userID.longValue());
            try {
                TwitterSocialNetwork.this.mTwitter.createFriendship(userID.longValue());
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_ADD_FRIEND", result.getLong(RESULT_REQUESTED_ID))) {
                return;
            }
            ((OnRequestAddFriendCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_ADD_FRIEND")).onRequestAddFriendComplete(TwitterSocialNetwork.this.getID(), "" + result.getLong(RESULT_REQUESTED_ID));
        }
    }

    private class RequestCheckIsFriendAsyncTask
    extends SocialNetworkAsyncTask {
        public static final String PARAM_USER_ID = "PARAM_USER_ID";
        public static final String RESULT_IS_FRIEND = "RESULT_IS_FRIEND";
        public static final String RESULT_REQUESTED_ID = "RESULT_REQUESTED_ID";

        private RequestCheckIsFriendAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Bundle args = params[0];
            Bundle result = new Bundle();
            Long userID = args.getLong(PARAM_USER_ID);
            result.putLong(RESULT_REQUESTED_ID, userID.longValue());
            try {
                long currentUserID = TwitterSocialNetwork.this.mSharedPreferences.getLong(TwitterSocialNetwork.SAVE_STATE_KEY_USER_ID, -1L);
                Relationship relationship = TwitterSocialNetwork.this.mTwitter.showFriendship(currentUserID, userID.longValue());
                result.putBoolean(RESULT_IS_FRIEND, relationship.isSourceFollowingTarget());
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_CHECK_IS_FRIEND", result.getLong(RESULT_REQUESTED_ID))) {
                return;
            }
            ((OnCheckIsFriendCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_CHECK_IS_FRIEND")).onCheckIsFriendComplete(TwitterSocialNetwork.this.getID(), "" + result.getLong(RESULT_REQUESTED_ID), result.getBoolean(RESULT_IS_FRIEND));
        }
    }

    private class RequestGetFriendsAsyncTask
    extends SocialNetworkAsyncTask {
        public static final String RESULT_GET_FRIENDS = "RESULT_GET_FRIENDS";
        public static final String RESULT_GET_FRIENDS_ID = "RESULT_GET_FRIENDS_ID";

        private RequestGetFriendsAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Bundle result = new Bundle();
            try {
                PagableResponseList friends;
                long cursor = -1L;
                long userID = TwitterSocialNetwork.this.mSharedPreferences.getLong(TwitterSocialNetwork.SAVE_STATE_KEY_USER_ID, -1L);
                ArrayList<String> friendIds = new ArrayList<String>();
                ArrayList<SocialPerson> socialPersons = new ArrayList<SocialPerson>();
                SocialPerson socialPerson = new SocialPerson();
                do {
                    friends = TwitterSocialNetwork.this.mTwitter.getFriendsList(userID, cursor);
                    for (User user : friends) {
                        friendIds.add(String.valueOf(user.getId()));
                        TwitterSocialNetwork.this.getSocialPerson(socialPerson, user);
                        socialPersons.add(socialPerson);
                        socialPerson = new SocialPerson();
                    }
                } while ((cursor = friends.getNextCursor()) != 0L);
                result.putStringArray(RESULT_GET_FRIENDS_ID, friendIds.toArray(new String[friendIds.size()]));
                result.putParcelableArrayList(RESULT_GET_FRIENDS, socialPersons);
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_GET_FRIENDS", result.getStringArray(RESULT_GET_FRIENDS_ID))) {
                return;
            }
            ((OnRequestGetFriendsCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_GET_FRIENDS")).OnGetFriendsIdComplete(TwitterSocialNetwork.this.getID(), result.getStringArray(RESULT_GET_FRIENDS_ID));
            ArrayList socialPersons = result.getParcelableArrayList(RESULT_GET_FRIENDS);
            ((OnRequestGetFriendsCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_GET_FRIENDS")).OnGetFriendsComplete(TwitterSocialNetwork.this.getID(), socialPersons);
        }
    }

    private class RequestUpdateStatusAsyncTask
    extends SocialNetworkAsyncTask {
        public static final String PARAM_MESSAGE = "RequestUpdateStatusAsyncTask.PARAM_MESSAGE";
        public static final String PARAM_PHOTO_PATH = "RequestUpdateStatusAsyncTask.PARAM_PHOTO_PATH";
        private static final String RESULT_POST_PHOTO = "RequestUpdateStatusAsyncTask.RESULT_POST_PHOTO";
        private static final String RESULT_POST_LINK = "RequestUpdateStatusAsyncTask.RESULT_POST_LINK";

        private RequestUpdateStatusAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Bundle args = params[0];
            Bundle result = new Bundle();
            String paramMessage = "";
            String paramPhotoPath = null;
            String paramLink = null;
            if (args.containsKey(PARAM_MESSAGE)) {
                paramMessage = args.getString(PARAM_MESSAGE);
            }
            if (args.containsKey(PARAM_PHOTO_PATH)) {
                paramPhotoPath = args.getString(PARAM_PHOTO_PATH);
                result.putBoolean(RESULT_POST_PHOTO, true);
            } else {
                result.putBoolean(RESULT_POST_PHOTO, false);
            }
            if (args.containsKey("link")) {
                paramLink = args.getString("link");
                result.putBoolean(RESULT_POST_LINK, true);
            } else {
                result.putBoolean(RESULT_POST_LINK, false);
            }
            try {
                StatusUpdate status = new StatusUpdate(paramMessage);
                if (paramPhotoPath != null) {
                    status.setMedia(new File(paramPhotoPath));
                }
                if (paramLink != null) {
                    status = new StatusUpdate(paramMessage + " " + paramLink);
                }
                TwitterSocialNetwork.this.mTwitter.updateStatus(status);
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            String error;
            String requestID = null;
            requestID = result.getBoolean(RESULT_POST_PHOTO) ? "SocialNetwork.REQUEST_POST_PHOTO" : (result.getBoolean(RESULT_POST_LINK) ? "SocialNetwork.REQUEST_POST_LINK" : "SocialNetwork.REQUEST_POST_MESSAGE");
            TwitterSocialNetwork.this.mRequests.remove(requestID);
            String string = error = result.containsKey("SocialNetworkAsyncTask.RESULT_ERROR") ? result.getString("SocialNetworkAsyncTask.RESULT_ERROR") : null;
            if (TwitterSocialNetwork.this.mLocalListeners.get(requestID) != null) {
                if (error == null) {
                    ((OnPostingCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get(requestID)).onPostSuccessfully(TwitterSocialNetwork.this.getID());
                } else {
                    ((SocialNetworkListener)TwitterSocialNetwork.this.mLocalListeners.get(requestID)).onError(TwitterSocialNetwork.this.getID(), requestID, error, null);
                }
            }
            TwitterSocialNetwork.this.mLocalListeners.remove(requestID);
        }

        protected void onCancelled() {
        }
    }

    private class RequestSocialPersonsAsyncTask
    extends SocialNetworkAsyncTask {
        public static final String PARAM_USER_ID = "RequestGetPersonAsyncTask.PARAM_USER_ID";
        private static final String RESULT_USERS_ARRAY = "RequestPersonAsyncTask.RESULT_USERS_ARRAY";

        private RequestSocialPersonsAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Bundle args = params[0];
            Bundle result = new Bundle();
            long[] userIDs = args.getLongArray(PARAM_USER_ID);
            try {
                ResponseList users = TwitterSocialNetwork.this.mTwitter.lookupUsers(userIDs);
                ArrayList<SocialPerson> socialUsers = new ArrayList<SocialPerson>();
                SocialPerson socialUser = new SocialPerson();
                for (User user : users) {
                    TwitterSocialNetwork.this.getSocialPerson(socialUser, user);
                    socialUsers.add(socialUser);
                    socialUser = new SocialPerson();
                }
                result.putParcelableArrayList(RESULT_USERS_ARRAY, socialUsers);
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            ArrayList arraylist = result.getParcelableArrayList(RESULT_USERS_ARRAY);
            if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_GET_PERSONS")) {
                return;
            }
            ((OnRequestSocialPersonsCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_GET_PERSONS")).onRequestSocialPersonsSuccess(TwitterSocialNetwork.this.getID(), arraylist);
        }
    }

    private class RequestGetDetailedPersonAsyncTask
    extends SocialNetworkAsyncTask {
        public static final String PARAM_USER_ID = "RequestGetPersonAsyncTask.PARAM_USER_ID";

        private RequestGetDetailedPersonAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Bundle args = params[0];
            Bundle result = new Bundle();
            Long userID = args.containsKey(PARAM_USER_ID) ? Long.valueOf(args.getLong(PARAM_USER_ID)) : Long.valueOf(TwitterSocialNetwork.this.mSharedPreferences.getLong(TwitterSocialNetwork.SAVE_STATE_KEY_USER_ID, -1L));
            try {
                User user = TwitterSocialNetwork.this.mTwitter.showUser(userID.longValue());
                TwitterPerson twitterPerson = new TwitterPerson();
                TwitterSocialNetwork.this.getDetailedSocialPerson(twitterPerson, user);
                result.putParcelable("SocialNetwork.REQUEST_GET_DETAIL_PERSON", (Parcelable)twitterPerson);
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_GET_DETAIL_PERSON")) {
                return;
            }
            TwitterPerson twitterPerson = (TwitterPerson)result.getParcelable("SocialNetwork.REQUEST_GET_DETAIL_PERSON");
            ((OnRequestDetailedSocialPersonCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_GET_DETAIL_PERSON")).onRequestDetailedSocialPersonSuccess(TwitterSocialNetwork.this.getID(), (SocialPerson)twitterPerson);
        }
    }

    private class RequestGetSocialPersonAsyncTask
    extends SocialNetworkAsyncTask {
        public static final String PARAM_USER_ID = "RequestGetPersonAsyncTask.PARAM_USER_ID";
        public static final String CURRENT = "RequestGetPersonAsyncTask.CURRENT";

        private RequestGetSocialPersonAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Long userID;
            Bundle args = params[0];
            Bundle result = new Bundle();
            if (args.containsKey(PARAM_USER_ID)) {
                userID = args.getLong(PARAM_USER_ID);
                result.putBoolean(CURRENT, false);
            } else {
                userID = TwitterSocialNetwork.this.mSharedPreferences.getLong(TwitterSocialNetwork.SAVE_STATE_KEY_USER_ID, -1L);
                result.putBoolean(CURRENT, true);
            }
            try {
                User user = TwitterSocialNetwork.this.mTwitter.showUser(userID.longValue());
                SocialPerson socialPerson = new SocialPerson();
                TwitterSocialNetwork.this.getSocialPerson(socialPerson, user);
                result.putParcelable("SocialNetwork.REQUEST_GET_PERSON", (Parcelable)socialPerson);
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            SocialPerson socialPerson = (SocialPerson)result.getParcelable("SocialNetwork.REQUEST_GET_PERSON");
            if (result.containsKey(CURRENT) && result.getBoolean(CURRENT)) {
                if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_GET_CURRENT_PERSON")) {
                    return;
                }
                ((OnRequestSocialPersonCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_GET_CURRENT_PERSON")).onRequestSocialPersonSuccess(TwitterSocialNetwork.this.getID(), socialPerson);
            } else {
                if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_GET_PERSON")) {
                    return;
                }
                ((OnRequestSocialPersonCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_GET_PERSON")).onRequestSocialPersonSuccess(TwitterSocialNetwork.this.getID(), socialPerson);
            }
        }
    }

    private class RequestLogin2AsyncTask
    extends SocialNetworkAsyncTask {
        public static final String PARAM_VERIFIER = "Login2AsyncTask.PARAM_VERIFIER";
        private static final String RESULT_TOKEN = "Login2AsyncTask.RESULT_TOKEN";
        private static final String RESULT_SECRET = "Login2AsyncTask.RESULT_SECRET";
        private static final String RESULT_USER_ID = "Login2AsyncTask.RESULT_USER_ID";

        private RequestLogin2AsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            String verifier = params[0].getString(PARAM_VERIFIER);
            Bundle result = new Bundle();
            try {
                AccessToken accessToken = TwitterSocialNetwork.this.mTwitter.getOAuthAccessToken(TwitterSocialNetwork.this.mRequestToken, verifier);
                result.putString(RESULT_TOKEN, accessToken.getToken());
                result.putString(RESULT_SECRET, accessToken.getTokenSecret());
                result.putLong(RESULT_USER_ID, accessToken.getUserId());
            }
            catch (Exception e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage() == null ? "canceled" : e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            TwitterSocialNetwork.this.mRequests.remove("SocialNetwork.REQUEST_LOGIN2");
            if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_LOGIN")) {
                TwitterSocialNetwork.this.initTwitterClient();
                return;
            }
            TwitterSocialNetwork.this.mSharedPreferences.edit().putString(TwitterSocialNetwork.SAVE_STATE_KEY_OAUTH_TOKEN, result.getString(RESULT_TOKEN)).putString(TwitterSocialNetwork.SAVE_STATE_KEY_OAUTH_SECRET, result.getString(RESULT_SECRET)).putLong(TwitterSocialNetwork.SAVE_STATE_KEY_USER_ID, result.getLong(RESULT_USER_ID)).apply();
            TwitterSocialNetwork.this.initTwitterClient();
            if (TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_LOGIN") != null) {
                ((OnLoginCompleteListener)TwitterSocialNetwork.this.mLocalListeners.get("SocialNetwork.REQUEST_LOGIN")).onLoginSuccess(TwitterSocialNetwork.this.getID());
            }
            TwitterSocialNetwork.this.mLocalListeners.remove("SocialNetwork.REQUEST_LOGIN");
        }
    }

    private class RequestLoginAsyncTask
    extends SocialNetworkAsyncTask {
        private static final String RESULT_OAUTH_LOGIN = "LoginAsyncTask.RESULT_OAUTH_LOGIN";

        private RequestLoginAsyncTask() {
        }

        protected Bundle doInBackground(Bundle ... params) {
            Bundle result = new Bundle();
            try {
                TwitterSocialNetwork.this.mRequestToken = TwitterSocialNetwork.this.mTwitter.getOAuthRequestToken(TwitterSocialNetwork.this.fRedirectURL);
                Uri oauthLoginURL = Uri.parse((String)(TwitterSocialNetwork.this.mRequestToken.getAuthenticationURL() + "&force_login=true"));
                result.putString(RESULT_OAUTH_LOGIN, oauthLoginURL.toString());
            }
            catch (TwitterException e) {
                result.putString("SocialNetworkAsyncTask.RESULT_ERROR", e.getMessage() == null ? "canceled" : e.getMessage());
            }
            return result;
        }

        protected void onPostExecute(Bundle result) {
            if (!TwitterSocialNetwork.this.handleRequestResult(result, "SocialNetwork.REQUEST_LOGIN")) {
                return;
            }
            if (result.containsKey(RESULT_OAUTH_LOGIN)) {
                Intent intent = new Intent((Context)TwitterSocialNetwork.this.mSocialNetworkManager.getActivity(), OAuthActivity.class).putExtra("OAuthActivity.PARAM_CALLBACK", TwitterSocialNetwork.this.fRedirectURL).putExtra("OAuthActivity.PARAM_URL_TO_LOAD", result.getString(RESULT_OAUTH_LOGIN));
                TwitterSocialNetwork.this.mSocialNetworkManager.getActivity().startActivityForResult(intent, REQUEST_AUTH);
            }
        }
    }
}

