/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.http;

import bt.BtException;
import bt.tracker.TrackerResponse;
import bt.tracker.http.HttpResponseHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

class CommonsHttpResponseHandler
implements ResponseHandler<TrackerResponse> {
    private Charset defaultHttpCharset = StandardCharsets.ISO_8859_1;
    private HttpResponseHandler httpResponseHandler;

    CommonsHttpResponseHandler(HttpResponseHandler httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
    }

    public TrackerResponse handleResponse(HttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return TrackerResponse.exceptional((Throwable)new BtException("Tracker returned error (" + statusLine.getStatusCode() + ": " + statusLine.getReasonPhrase() + ")"));
        }
        if (entity == null) {
            return TrackerResponse.exceptional((Throwable)new BtException("Tracker response is empty"));
        }
        try {
            Charset charset = null;
            ContentType contentType = ContentType.get((HttpEntity)entity);
            if (contentType != null) {
                charset = contentType.getCharset();
            }
            if (charset == null) {
                charset = this.defaultHttpCharset;
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)bytes);
            return this.httpResponseHandler.handleResponse(bytes.toByteArray(), charset);
        }
        catch (IOException e) {
            return TrackerResponse.exceptional((Throwable)new BtException("Failed to read tracker response", (Throwable)e));
        }
    }
}

