/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.http;

import bt.BtException;
import bt.bencoding.model.BEObject;
import bt.bencoding.model.BEObjectModel;
import bt.bencoding.model.ClassUtil;
import bt.bencoding.model.ValidationResult;
import bt.bencoding.model.YamlBEObjectModelLoader;
import bt.bencoding.serializers.BEParser;
import bt.bencoding.types.BEMap;
import bt.tracker.CompactPeerInfo;
import bt.tracker.TrackerResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;

class HttpResponseHandler {
    private static final String FAILURE_REASON_KEY = "failure reason";
    private static final String WARNING_MESSAGE_KEY = "warning message";
    private static final String INTERVAL_KEY = "interval";
    private static final String MIN_INTERVAL_KEY = "min interval";
    private static final String TRACKER_ID_KEY = "tracker id";
    private static final String COMPLETE_KEY = "complete";
    private static final String INCOMPLETE_KEY = "incomplete";
    private static final String PEERS_KEY = "peers";
    private static final String CRYPTO_FLAGS_KEY = "crypto_flags";
    private BEObjectModel trackerResponseModel;

    public HttpResponseHandler() {
        try (InputStream in = HttpResponseHandler.class.getResourceAsStream("/tracker_response.yml");){
            this.trackerResponseModel = new YamlBEObjectModelLoader().load(in);
        }
        catch (IOException e) {
            throw new BtException("Failed to create tracker response handler", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TrackerResponse handleResponse(InputStream in, Charset charset) {
        try (BEParser parser = new BEParser(in);){
            TrackerResponse trackerResponse = this.handleResponse(parser, charset);
            return trackerResponse;
        }
        catch (Exception e) {
            return TrackerResponse.exceptional((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TrackerResponse handleResponse(byte[] bytes, Charset charset) {
        try (BEParser parser = new BEParser(bytes);){
            TrackerResponse trackerResponse = this.handleResponse(parser, charset);
            return trackerResponse;
        }
        catch (Exception e) {
            return TrackerResponse.exceptional((Throwable)e);
        }
    }

    private TrackerResponse handleResponse(BEParser parser, Charset charset) {
        BEMap responseMap = parser.readMap();
        ValidationResult validationResult = this.trackerResponseModel.validate((Object)responseMap);
        if (!validationResult.isSuccess()) {
            return TrackerResponse.exceptional((Throwable)new BtException("Validation failed for tracker response: " + Arrays.toString(validationResult.getMessages().toArray())));
        }
        try {
            return this.buildResponse(responseMap, charset);
        }
        catch (Exception e) {
            return TrackerResponse.exceptional((Throwable)new BtException("Invalid tracker response format", (Throwable)e));
        }
    }

    private TrackerResponse buildResponse(BEMap root, Charset charset) throws Exception {
        TrackerResponse response;
        Map responseMap = root.getValue();
        if (responseMap.get(FAILURE_REASON_KEY) != null) {
            byte[] failureReason = (byte[])ClassUtil.cast(byte[].class, (Object)FAILURE_REASON_KEY, (Object)((BEObject)responseMap.get(FAILURE_REASON_KEY)).getValue());
            response = TrackerResponse.failure((String)new String(failureReason, charset));
        } else {
            response = TrackerResponse.ok();
            if (responseMap.get(WARNING_MESSAGE_KEY) != null) {
                byte[] warningMessage = (byte[])ClassUtil.cast(byte[].class, (Object)WARNING_MESSAGE_KEY, (Object)((BEObject)responseMap.get(WARNING_MESSAGE_KEY)).getValue());
                response.setWarningMessage(new String(warningMessage, charset));
            }
            Number interval = (Number)ClassUtil.cast(Number.class, (Object)INTERVAL_KEY, (Object)((BEObject)responseMap.get(INTERVAL_KEY)).getValue());
            response.setInterval(interval.intValue());
            if (responseMap.get(MIN_INTERVAL_KEY) != null) {
                Number minInterval = (Number)ClassUtil.cast(Number.class, (Object)MIN_INTERVAL_KEY, (Object)((BEObject)responseMap.get(MIN_INTERVAL_KEY)).getValue());
                response.setMinInterval(minInterval.intValue());
            }
            if (responseMap.get(TRACKER_ID_KEY) != null) {
                byte[] trackerId = (byte[])ClassUtil.cast(byte[].class, (Object)TRACKER_ID_KEY, (Object)((BEObject)responseMap.get(TRACKER_ID_KEY)).getValue());
                response.setTrackerId(trackerId);
            }
            if (responseMap.get(COMPLETE_KEY) != null) {
                Number complete = (Number)ClassUtil.cast(Number.class, (Object)COMPLETE_KEY, (Object)((BEObject)responseMap.get(COMPLETE_KEY)).getValue());
                response.setSeederCount(complete.intValue());
            }
            if (responseMap.get(INCOMPLETE_KEY) != null) {
                Number incomplete = (Number)ClassUtil.cast(Number.class, (Object)INCOMPLETE_KEY, (Object)((BEObject)responseMap.get(INCOMPLETE_KEY)).getValue());
                response.setLeecherCount(incomplete.intValue());
            }
            byte[] peers = (byte[])ClassUtil.cast(byte[].class, (Object)PEERS_KEY, (Object)((BEObject)responseMap.get(PEERS_KEY)).getValue());
            if (responseMap.get(CRYPTO_FLAGS_KEY) != null) {
                byte[] cryptoFlags = (byte[])ClassUtil.cast(byte[].class, (Object)CRYPTO_FLAGS_KEY, (Object)((BEObject)responseMap.get(CRYPTO_FLAGS_KEY)).getValue());
                response.setPeers((Iterable)new CompactPeerInfo(peers, CompactPeerInfo.AddressType.IPV4, cryptoFlags));
            } else {
                response.setPeers((Iterable)new CompactPeerInfo(peers, CompactPeerInfo.AddressType.IPV4));
            }
        }
        return response;
    }
}

