/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.http;

import bt.peer.IPeerRegistry;
import bt.protocol.crypto.EncryptionPolicy;
import bt.runtime.Config;
import bt.service.IdentityService;
import bt.torrent.TorrentRegistry;
import bt.tracker.Tracker;
import bt.tracker.TrackerFactory;
import bt.tracker.http.HttpTracker;
import com.google.inject.Inject;
import java.net.InetAddress;
import java.time.Duration;

public class HttpTrackerFactory
implements TrackerFactory {
    private final TorrentRegistry torrentRegistry;
    private final IdentityService idService;
    private final IPeerRegistry peerRegistry;
    private final EncryptionPolicy encryptionPolicy;
    private final InetAddress localAddress;
    private final int numberOfPeersToRequestFromTracker;
    private final Duration trackerTimeout;

    @Inject
    public HttpTrackerFactory(TorrentRegistry torrentRegistry, IdentityService idService, IPeerRegistry peerRegistry, Config config) {
        this.torrentRegistry = torrentRegistry;
        this.idService = idService;
        this.peerRegistry = peerRegistry;
        this.encryptionPolicy = config.getEncryptionPolicy();
        this.localAddress = config.getAcceptorAddress();
        this.numberOfPeersToRequestFromTracker = config.getNumberOfPeersToRequestFromTracker();
        this.trackerTimeout = config.getTrackerTimeout();
    }

    public Tracker getTracker(String trackerUrl) {
        return new HttpTracker(trackerUrl, this.torrentRegistry, this.idService, this.peerRegistry, this.encryptionPolicy, this.localAddress, this.numberOfPeersToRequestFromTracker, this.trackerTimeout);
    }
}

