/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.http.urlencoding;

import com.google.common.base.CharMatcher;
import com.google.common.primitives.Longs;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BinaryQueryNamedValue {
    private static final CharMatcher SAFE_CHAR = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.anyOf((CharSequence)"-._~"));
    private final String name;
    private final byte[] value;

    public BinaryQueryNamedValue(String name, byte[] value) {
        this.name = name;
        this.value = value;
        if (!SAFE_CHAR.matchesAllOf((CharSequence)name)) {
            throw new IllegalArgumentException("name must be safe: " + name);
        }
    }

    public BinaryQueryNamedValue(String name, String value) {
        this(name, value, StandardCharsets.UTF_8);
    }

    public BinaryQueryNamedValue(String name, String value, Charset wireEncoding) {
        this(name, value.getBytes(wireEncoding));
    }

    public BinaryQueryNamedValue(String name, long value) {
        this(name, Long.toString(value), StandardCharsets.US_ASCII);
    }

    public String getName() {
        return this.name;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getValueAsUtf8Str() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public String getValue(Charset charset) {
        return new String(this.value, charset);
    }

    public long getValueAsLong() {
        Long ret = Longs.tryParse((String)this.getValue(StandardCharsets.US_ASCII));
        if (ret == null) {
            throw new IllegalStateException();
        }
        return ret;
    }

    public String getUrlEncodedValue() {
        StringBuilder ret = new StringBuilder();
        for (byte b : this.value) {
            if (SAFE_CHAR.matches((char)b)) {
                ret.append((char)b);
                continue;
            }
            ret.append('%');
            ret.append(this.lowerBitsToAscii(b >> 4));
            ret.append(this.lowerBitsToAscii(b));
        }
        return ret.toString();
    }

    private char lowerBitsToAscii(int b) {
        int lowerFourBits = b & 0xF;
        if (lowerFourBits < 10) {
            return (char)(48 + lowerFourBits);
        }
        return (char)(65 + (lowerFourBits - 10));
    }
}

