package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.DeleteMessageForMeAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DeleteMessageForMeActionSpec {
    public static byte[] encode(DeleteMessageForMeAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.deleteMedia());
outputStream.writeInt64(2, protoInputObject.messageTimestampSeconds());
      return outputStream.toByteArray();
    }

    public static DeleteMessageForMeAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean deleteMedia = false;
        long messageTimestampSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> deleteMedia = inputStream.readBool();
                case 2 -> messageTimestampSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.DeleteMessageForMeAction(deleteMedia, messageTimestampSeconds);
    }

}
