package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.LabelAssociationAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class LabelAssociationActionSpec {
    public static byte[] encode(LabelAssociationAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.labeled());
      return outputStream.toByteArray();
    }

    public static LabelAssociationAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean labeled = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> labeled = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.LabelAssociationAction(labeled);
    }

}
