package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.NuxAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NuxActionSpec {
    public static byte[] encode(NuxAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.acknowledged());
      return outputStream.toByteArray();
    }

    public static NuxAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean acknowledged = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> acknowledged = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.NuxAction(acknowledged);
    }

}
