package it.auties.whatsapp.model.action;

import it.auties.whatsapp.model.action.PinAction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PinActionSpec {
    public static byte[] encode(PinAction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBool(1, protoInputObject.pinned());
      return outputStream.toByteArray();
    }

    public static PinAction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        boolean pinned = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> pinned = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.action.PinAction(pinned);
    }

}
