package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessAccountPayload;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class BusinessAccountPayloadSpec {
    public static byte[] encode(BusinessAccountPayload protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec.encode(protoInputObject.certificate()));
outputStream.writeBytes(2, protoInputObject.info());
      return outputStream.toByteArray();
    }

    public static BusinessAccountPayload decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate certificate = null;
        byte[] info = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> certificate = it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec.decode(inputStream.readBytes());
                case 2 -> info = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.business.BusinessAccountPayload(certificate, info);
    }

}
