package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessLocalizedName;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class BusinessLocalizedNameSpec {
    public static byte[] encode(BusinessLocalizedName protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.lg());
outputStream.writeString(2, protoInputObject.lc());
outputStream.writeString(3, protoInputObject.name());
      return outputStream.toByteArray();
    }

    public static BusinessLocalizedName decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String lg = null;
        java.lang.String lc = null;
        java.lang.String name = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> lg = inputStream.readString();
                case 2 -> lc = inputStream.readString();
                case 3 -> name = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.business.BusinessLocalizedName(lg, lc, name);
    }

}
