package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class BusinessVerifiedNameCertificateSpec {
    public static byte[] encode(BusinessVerifiedNameCertificate protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.encodedDetails());
outputStream.writeBytes(2, protoInputObject.signature());
outputStream.writeBytes(3, protoInputObject.serverSignature());
      return outputStream.toByteArray();
    }

    public static BusinessVerifiedNameCertificate decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] encodedDetails = null;
        byte[] signature = null;
        byte[] serverSignature = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> encodedDetails = inputStream.readBytes();
                case 2 -> signature = inputStream.readBytes();
                case 3 -> serverSignature = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate(encodedDetails, signature, serverSignature);
    }

}
