package it.auties.whatsapp.model.button.base;

import it.auties.whatsapp.model.button.base.ButtonActionLink;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ButtonActionLinkSpec {
    public static byte[] encode(ButtonActionLink protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.url());
outputStream.writeString(2, protoInputObject.buttonTitle());
      return outputStream.toByteArray();
    }

    public static ButtonActionLink decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String url = null;
        java.lang.String buttonTitle = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> url = inputStream.readString();
                case 2 -> buttonTitle = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.base.ButtonActionLink(url, buttonTitle);
    }

}
