package it.auties.whatsapp.model.button.base;

import it.auties.whatsapp.model.button.base.ButtonText;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ButtonTextSpec {
    public static byte[] encode(ButtonText protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.content());
      return outputStream.toByteArray();
    }

    public static ButtonText decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String content = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> content = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.base.ButtonText(content);
    }

}
