package it.auties.whatsapp.model.button.interactive;

import it.auties.whatsapp.model.button.interactive.InteractiveHeader;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class InteractiveHeaderSpec {
    public static byte[] encode(InteractiveHeader protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.title());
var subtitle = protoInputObject.subtitle();
var subtitle0 = subtitle.orElse(null);
if(subtitle0 != null) {
outputStream.writeString(2, subtitle0);
}
var attachmentDocument = protoInputObject.attachmentDocument();
var attachmentDocument0 = attachmentDocument.orElse(null);
if(attachmentDocument0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.message.standard.DocumentMessageSpec.encode(attachmentDocument0));
}
var attachmentImage = protoInputObject.attachmentImage();
var attachmentImage0 = attachmentImage.orElse(null);
if(attachmentImage0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.message.standard.ImageMessageSpec.encode(attachmentImage0));
}
outputStream.writeBool(5, protoInputObject.mediaAttachment());
var attachmentThumbnail = protoInputObject.attachmentThumbnail();
var attachmentThumbnail0 = attachmentThumbnail.orElse(null);
if(attachmentThumbnail0 != null) {
var attachmentThumbnail1 = attachmentThumbnail0.thumbnail();
if(attachmentThumbnail1 != null) {
outputStream.writeBytes(6, attachmentThumbnail1);
}
}
var attachmentVideo = protoInputObject.attachmentVideo();
var attachmentVideo0 = attachmentVideo.orElse(null);
if(attachmentVideo0 != null) {
outputStream.writeBytes(7, it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec.encode(attachmentVideo0));
}
      return outputStream.toByteArray();
    }

    public static InteractiveHeader decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String title = null;
        java.util.Optional<java.lang.String> subtitle = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.DocumentMessage> attachmentDocument = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.ImageMessage> attachmentImage = java.util.Optional.empty();
        boolean mediaAttachment = false;
        java.util.Optional<it.auties.whatsapp.model.button.interactive.InteractiveHeaderThumbnail> attachmentThumbnail = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.VideoOrGifMessage> attachmentVideo = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> title = inputStream.readString();
                case 2 -> subtitle = java.util.Optional.ofNullable(inputStream.readString());
                case 3 -> attachmentDocument = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.DocumentMessageSpec.decode(inputStream.readBytes()));
                case 4 -> attachmentImage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.ImageMessageSpec.decode(inputStream.readBytes()));
                case 5 -> mediaAttachment = inputStream.readBool();
                case 6 -> attachmentThumbnail = java.util.Optional.ofNullable(it.auties.whatsapp.model.button.interactive.InteractiveHeaderThumbnail.of(inputStream.readBytes()));
                case 7 -> attachmentVideo = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.interactive.InteractiveHeader(title, subtitle, attachmentDocument, attachmentImage, mediaAttachment, attachmentThumbnail, attachmentVideo);
    }

}
