package it.auties.whatsapp.model.button.interactive;

import it.auties.whatsapp.model.button.interactive.InteractiveNativeFlow;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class InteractiveNativeFlowSpec {
    public static byte[] encode(InteractiveNativeFlow protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
      if(protoInputObject.buttons() != null) {
       for(var buttonsEntry : protoInputObject.buttons()) {
outputStream.writeBytes(1, it.auties.whatsapp.model.button.interactive.InteractiveButtonSpec.encode(buttonsEntry));
       }
      }
outputStream.writeString(2, protoInputObject.parameters());
outputStream.writeInt32(3, protoInputObject.version());
      return outputStream.toByteArray();
    }

    public static InteractiveNativeFlow decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.List<it.auties.whatsapp.model.button.interactive.InteractiveButton> buttons = new java.util.ArrayList<it.auties.whatsapp.model.button.interactive.InteractiveButton>();
        java.lang.String parameters = null;
        int version = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> buttons.add(it.auties.whatsapp.model.button.interactive.InteractiveButtonSpec.decode(inputStream.readBytes()));
                case 2 -> parameters = inputStream.readString();
                case 3 -> version = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.interactive.InteractiveNativeFlow(buttons, parameters, version);
    }

}
