package it.auties.whatsapp.model.button.interactive;

import it.auties.whatsapp.model.button.interactive.InteractivePoint;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class InteractivePointSpec {
    public static byte[] encode(InteractivePoint protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.xDeprecated());
outputStream.writeInt32(2, protoInputObject.yDeprecated());
outputStream.writeDouble(3, protoInputObject.x());
outputStream.writeDouble(4, protoInputObject.y());
      return outputStream.toByteArray();
    }

    public static InteractivePoint decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int xDeprecated = 0;
        int yDeprecated = 0;
        double x = 0d;
        double y = 0d;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> xDeprecated = inputStream.readInt32();
                case 2 -> yDeprecated = inputStream.readInt32();
                case 3 -> x = inputStream.readDouble();
                case 4 -> y = inputStream.readDouble();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.interactive.InteractivePoint(xDeprecated, yDeprecated, x, y);
    }

}
