package it.auties.whatsapp.model.button.interactive;

import it.auties.whatsapp.model.button.interactive.InteractiveShop;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class InteractiveShopSpec {
    public static byte[] encode(InteractiveShop protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
outputStream.writeInt32(2, it.auties.whatsapp.model.button.interactive.InteractiveShopSurfaceTypeSpec.encode(protoInputObject.surfaceType()));
outputStream.writeInt32(3, protoInputObject.version());
      return outputStream.toByteArray();
    }

    public static InteractiveShop decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        it.auties.whatsapp.model.button.interactive.InteractiveShop.SurfaceType surfaceType = null;
        int version = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> surfaceType = it.auties.whatsapp.model.button.interactive.InteractiveShopSurfaceTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 3 -> version = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.interactive.InteractiveShop(id, surfaceType, version);
    }

}
