package it.auties.whatsapp.model.button.interactive;

import it.auties.whatsapp.model.button.interactive.InterativeLocation;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class InterativeLocationSpec {
    public static byte[] encode(InterativeLocation protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeDouble(1, protoInputObject.latitude());
outputStream.writeDouble(2, protoInputObject.longitude());
outputStream.writeString(3, protoInputObject.name());
      return outputStream.toByteArray();
    }

    public static InterativeLocation decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        double latitude = 0d;
        double longitude = 0d;
        java.lang.String name = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> latitude = inputStream.readDouble();
                case 2 -> longitude = inputStream.readDouble();
                case 3 -> name = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.interactive.InterativeLocation(latitude, longitude, name);
    }

}
