package it.auties.whatsapp.model.button.misc;

import it.auties.whatsapp.model.button.misc.ButtonOpaqueData;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ButtonOpaqueDataSpec {
    public static byte[] encode(ButtonOpaqueData protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var body = protoInputObject.body();
var body0 = body.orElse(null);
if(body0 != null) {
outputStream.writeString(1, body0);
}
var caption = protoInputObject.caption();
var caption0 = caption.orElse(null);
if(caption0 != null) {
outputStream.writeString(3, caption0);
}
outputStream.writeDouble(5, protoInputObject.longitude());
outputStream.writeDouble(7, protoInputObject.latitude());
outputStream.writeInt32(8, protoInputObject.paymentAmount1000());
var paymentNote = protoInputObject.paymentNote();
var paymentNote0 = paymentNote.orElse(null);
if(paymentNote0 != null) {
outputStream.writeString(9, paymentNote0);
}
var canonicalUrl = protoInputObject.canonicalUrl();
var canonicalUrl0 = canonicalUrl.orElse(null);
if(canonicalUrl0 != null) {
outputStream.writeString(10, canonicalUrl0);
}
var matchedText = protoInputObject.matchedText();
var matchedText0 = matchedText.orElse(null);
if(matchedText0 != null) {
outputStream.writeString(11, matchedText0);
}
var title = protoInputObject.title();
var title0 = title.orElse(null);
if(title0 != null) {
outputStream.writeString(12, title0);
}
var description = protoInputObject.description();
var description0 = description.orElse(null);
if(description0 != null) {
outputStream.writeString(13, description0);
}
outputStream.writeBool(6, protoInputObject.isLive());
var futureProofBuffer = protoInputObject.futureProofBuffer();
var futureProofBuffer0 = futureProofBuffer.orElse(null);
if(futureProofBuffer0 != null) {
outputStream.writeBytes(14, futureProofBuffer0);
}
var clientUrl = protoInputObject.clientUrl();
var clientUrl0 = clientUrl.orElse(null);
if(clientUrl0 != null) {
outputStream.writeString(15, clientUrl0);
}
var loc = protoInputObject.loc();
var loc0 = loc.orElse(null);
if(loc0 != null) {
outputStream.writeString(16, loc0);
}
var pollName = protoInputObject.pollName();
var pollName0 = pollName.orElse(null);
if(pollName0 != null) {
outputStream.writeString(17, pollName0);
}
      if(protoInputObject.pollOptions() != null) {
       for(var pollOptionsEntry : protoInputObject.pollOptions()) {
outputStream.writeBytes(18, it.auties.whatsapp.model.poll.PollOptionSpec.encode(pollOptionsEntry));
       }
      }
outputStream.writeUInt32(20, protoInputObject.pollSelectableOptionsCount());
var messageSecret = protoInputObject.messageSecret();
var messageSecret0 = messageSecret.orElse(null);
if(messageSecret0 != null) {
outputStream.writeBytes(21, messageSecret0);
}
var originalSelfAuthor = protoInputObject.originalSelfAuthor();
var originalSelfAuthor0 = originalSelfAuthor.orElse(null);
if(originalSelfAuthor0 != null) {
outputStream.writeString(51, originalSelfAuthor0);
}
outputStream.writeInt64(22, protoInputObject.senderTimestampMs());
var pollUpdateParentKey = protoInputObject.pollUpdateParentKey();
var pollUpdateParentKey0 = pollUpdateParentKey.orElse(null);
if(pollUpdateParentKey0 != null) {
outputStream.writeString(23, pollUpdateParentKey0);
}
var encPollVote = protoInputObject.encPollVote();
var encPollVote0 = encPollVote.orElse(null);
if(encPollVote0 != null) {
outputStream.writeBytes(24, it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadataSpec.encode(encPollVote0));
}
var encReactionTargetMessageKey = protoInputObject.encReactionTargetMessageKey();
var encReactionTargetMessageKey0 = encReactionTargetMessageKey.orElse(null);
if(encReactionTargetMessageKey0 != null) {
outputStream.writeString(25, encReactionTargetMessageKey0);
}
var encReactionEncPayload = protoInputObject.encReactionEncPayload();
var encReactionEncPayload0 = encReactionEncPayload.orElse(null);
if(encReactionEncPayload0 != null) {
outputStream.writeBytes(26, encReactionEncPayload0);
}
var encReactionEncIv = protoInputObject.encReactionEncIv();
var encReactionEncIv0 = encReactionEncIv.orElse(null);
if(encReactionEncIv0 != null) {
outputStream.writeBytes(27, encReactionEncIv0);
}
      return outputStream.toByteArray();
    }

    public static ButtonOpaqueData decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.Optional<java.lang.String> body = java.util.Optional.empty();
        java.util.Optional<java.lang.String> caption = java.util.Optional.empty();
        double longitude = 0d;
        double latitude = 0d;
        int paymentAmount1000 = 0;
        java.util.Optional<java.lang.String> paymentNote = java.util.Optional.empty();
        java.util.Optional<java.lang.String> canonicalUrl = java.util.Optional.empty();
        java.util.Optional<java.lang.String> matchedText = java.util.Optional.empty();
        java.util.Optional<java.lang.String> title = java.util.Optional.empty();
        java.util.Optional<java.lang.String> description = java.util.Optional.empty();
        boolean isLive = false;
        java.util.Optional<byte[]> futureProofBuffer = java.util.Optional.empty();
        java.util.Optional<java.lang.String> clientUrl = java.util.Optional.empty();
        java.util.Optional<java.lang.String> loc = java.util.Optional.empty();
        java.util.Optional<java.lang.String> pollName = java.util.Optional.empty();
        java.util.List<it.auties.whatsapp.model.poll.PollOption> pollOptions = new java.util.ArrayList<it.auties.whatsapp.model.poll.PollOption>();
        int pollSelectableOptionsCount = 0;
        java.util.Optional<byte[]> messageSecret = java.util.Optional.empty();
        java.util.Optional<java.lang.String> originalSelfAuthor = java.util.Optional.empty();
        long senderTimestampMs = 0l;
        java.util.Optional<java.lang.String> pollUpdateParentKey = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata> encPollVote = java.util.Optional.empty();
        java.util.Optional<java.lang.String> encReactionTargetMessageKey = java.util.Optional.empty();
        java.util.Optional<byte[]> encReactionEncPayload = java.util.Optional.empty();
        java.util.Optional<byte[]> encReactionEncIv = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> body = java.util.Optional.ofNullable(inputStream.readString());
                case 3 -> caption = java.util.Optional.ofNullable(inputStream.readString());
                case 5 -> longitude = inputStream.readDouble();
                case 7 -> latitude = inputStream.readDouble();
                case 8 -> paymentAmount1000 = inputStream.readInt32();
                case 9 -> paymentNote = java.util.Optional.ofNullable(inputStream.readString());
                case 10 -> canonicalUrl = java.util.Optional.ofNullable(inputStream.readString());
                case 11 -> matchedText = java.util.Optional.ofNullable(inputStream.readString());
                case 12 -> title = java.util.Optional.ofNullable(inputStream.readString());
                case 13 -> description = java.util.Optional.ofNullable(inputStream.readString());
                case 6 -> isLive = inputStream.readBool();
                case 14 -> futureProofBuffer = java.util.Optional.ofNullable(inputStream.readBytes());
                case 15 -> clientUrl = java.util.Optional.ofNullable(inputStream.readString());
                case 16 -> loc = java.util.Optional.ofNullable(inputStream.readString());
                case 17 -> pollName = java.util.Optional.ofNullable(inputStream.readString());
                case 18 -> pollOptions.add(it.auties.whatsapp.model.poll.PollOptionSpec.decode(inputStream.readBytes()));
                case 20 -> pollSelectableOptionsCount = inputStream.readInt32();
                case 21 -> messageSecret = java.util.Optional.ofNullable(inputStream.readBytes());
                case 51 -> originalSelfAuthor = java.util.Optional.ofNullable(inputStream.readString());
                case 22 -> senderTimestampMs = inputStream.readInt64();
                case 23 -> pollUpdateParentKey = java.util.Optional.ofNullable(inputStream.readString());
                case 24 -> encPollVote = java.util.Optional.ofNullable(it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadataSpec.decode(inputStream.readBytes()));
                case 25 -> encReactionTargetMessageKey = java.util.Optional.ofNullable(inputStream.readString());
                case 26 -> encReactionEncPayload = java.util.Optional.ofNullable(inputStream.readBytes());
                case 27 -> encReactionEncIv = java.util.Optional.ofNullable(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.misc.ButtonOpaqueData(body, caption, longitude, latitude, paymentAmount1000, paymentNote, canonicalUrl, matchedText, title, description, isLive, futureProofBuffer, clientUrl, loc, pollName, pollOptions, pollSelectableOptionsCount, messageSecret, originalSelfAuthor, senderTimestampMs, pollUpdateParentKey, encPollVote, encReactionTargetMessageKey, encReactionEncPayload, encReactionEncIv);
    }

}
