package it.auties.whatsapp.model.button.template.hydrated;

import it.auties.whatsapp.model.button.template.hydrated.HydratedCallButton;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HydratedCallButtonSpec {
    public static byte[] encode(HydratedCallButton protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.text());
outputStream.writeString(2, protoInputObject.phoneNumber());
      return outputStream.toByteArray();
    }

    public static HydratedCallButton decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String text = null;
        java.lang.String phoneNumber = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> text = inputStream.readString();
                case 2 -> phoneNumber = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.template.hydrated.HydratedCallButton(text, phoneNumber);
    }

}
