package it.auties.whatsapp.model.button.template.hydrated;

import it.auties.whatsapp.model.button.template.hydrated.HydratedTemplateButton;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HydratedTemplateButtonSpec {
    public static byte[] encode(HydratedTemplateButton protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.button.template.hydrated.HydratedQuickReplyButtonSpec.encode(protoInputObject.quickReplyButton()));
outputStream.writeBytes(2, it.auties.whatsapp.model.button.template.hydrated.HydratedURLButtonSpec.encode(protoInputObject.urlButton()));
outputStream.writeBytes(3, it.auties.whatsapp.model.button.template.hydrated.HydratedCallButtonSpec.encode(protoInputObject.callButton()));
outputStream.writeUInt32(4, protoInputObject.index());
      return outputStream.toByteArray();
    }

    public static HydratedTemplateButton decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.button.template.hydrated.HydratedQuickReplyButton quickReplyButton = null;
        it.auties.whatsapp.model.button.template.hydrated.HydratedURLButton urlButton = null;
        it.auties.whatsapp.model.button.template.hydrated.HydratedCallButton callButton = null;
        int index = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> quickReplyButton = it.auties.whatsapp.model.button.template.hydrated.HydratedQuickReplyButtonSpec.decode(inputStream.readBytes());
                case 2 -> urlButton = it.auties.whatsapp.model.button.template.hydrated.HydratedURLButtonSpec.decode(inputStream.readBytes());
                case 3 -> callButton = it.auties.whatsapp.model.button.template.hydrated.HydratedCallButtonSpec.decode(inputStream.readBytes());
                case 4 -> index = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.template.hydrated.HydratedTemplateButton(quickReplyButton, urlButton, callButton, index);
    }

}
