package it.auties.whatsapp.model.button.template.hydrated;

import it.auties.whatsapp.model.button.template.hydrated.HydratedURLButton;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HydratedURLButtonSpec {
    public static byte[] encode(HydratedURLButton protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.text());
outputStream.writeString(2, protoInputObject.url());
      return outputStream.toByteArray();
    }

    public static HydratedURLButton decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String text = null;
        java.lang.String url = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> text = inputStream.readString();
                case 2 -> url = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.button.template.hydrated.HydratedURLButton(text, url);
    }

}
