package it.auties.whatsapp.model.chat;

import it.auties.whatsapp.model.chat.Chat;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ChatSpec {
    public static byte[] encode(Chat protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var jid = protoInputObject.jid();
if(jid != null) {
var jid0 = jid.toProtobufValue();
if(jid0 != null) {
outputStream.writeString(1, jid0);
}
}
      if(protoInputObject.historySyncMessages() != null) {
       for(var historySyncMessagesEntry : protoInputObject.historySyncMessages()) {
outputStream.writeBytes(2, it.auties.whatsapp.model.sync.HistorySyncMessageSpec.encode(historySyncMessagesEntry));
       }
      }
var newJid = protoInputObject.newJid();
if(newJid != null) {
var newJid0 = newJid.orElse(null);
if(newJid0 != null) {
var newJid1 = newJid0.toProtobufValue();
if(newJid1 != null) {
outputStream.writeString(3, newJid1);
}
}
}
var oldJid = protoInputObject.oldJid();
if(oldJid != null) {
var oldJid0 = oldJid.orElse(null);
if(oldJid0 != null) {
var oldJid1 = oldJid0.toProtobufValue();
if(oldJid1 != null) {
outputStream.writeString(4, oldJid1);
}
}
}
outputStream.writeUInt32(6, protoInputObject.unreadMessagesCount());
outputStream.writeBool(7, protoInputObject.readOnly());
outputStream.writeBool(8, protoInputObject.endOfHistoryTransfer());
var ephemeralMessageDuration = protoInputObject.ephemeralMessageDuration();
if(ephemeralMessageDuration != null) {
var ephemeralMessageDuration0 = ephemeralMessageDuration.periodSeconds();
outputStream.writeUInt32(9, ephemeralMessageDuration0);
}
outputStream.writeInt64(10, protoInputObject.ephemeralMessagesToggleTimeSeconds());
var endOfHistoryTransferType = protoInputObject.endOfHistoryTransferType();
if(endOfHistoryTransferType != null) {
var endOfHistoryTransferType0 = endOfHistoryTransferType.orElse(null);
if(endOfHistoryTransferType0 != null) {
outputStream.writeInt32(11, it.auties.whatsapp.model.chat.ChatEndOfHistoryTransferTypeSpec.encode(endOfHistoryTransferType0));
}
}
outputStream.writeUInt64(12, protoInputObject.timestampSeconds());
outputStream.writeString(13, protoInputObject.name());
outputStream.writeBool(15, protoInputObject.notSpam());
outputStream.writeBool(16, protoInputObject.archived());
var disappearInitiator = protoInputObject.disappearInitiator();
if(disappearInitiator != null) {
var disappearInitiator0 = disappearInitiator.orElse(null);
if(disappearInitiator0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.chat.ChatDisappearSpec.encode(disappearInitiator0));
}
}
outputStream.writeBool(19, protoInputObject.markedAsUnread());
      if(protoInputObject.participants() != null) {
       for(var participantsEntry : protoInputObject.participants()) {
outputStream.writeBytes(20, it.auties.whatsapp.model.chat.GroupParticipantSpec.encode(participantsEntry));
       }
      }
var token = protoInputObject.token();
if(token != null) {
var token0 = token.orElse(null);
if(token0 != null) {
outputStream.writeBytes(21, token0);
}
}
outputStream.writeUInt64(22, protoInputObject.tokenTimestampSeconds());
var identityKey = protoInputObject.identityKey();
if(identityKey != null) {
var identityKey0 = identityKey.orElse(null);
if(identityKey0 != null) {
outputStream.writeBytes(23, identityKey0);
}
}
outputStream.writeUInt32(24, protoInputObject.pinnedTimestampSeconds());
var mute = protoInputObject.mute();
if(mute != null) {
var mute0 = mute.endTimeStamp();
outputStream.writeUInt64(25, mute0);
}
var wallpaper = protoInputObject.wallpaper();
if(wallpaper != null) {
var wallpaper0 = wallpaper.orElse(null);
if(wallpaper0 != null) {
outputStream.writeBytes(26, it.auties.whatsapp.model.chat.ChatWallpaperSpec.encode(wallpaper0));
}
}
outputStream.writeInt32(27, it.auties.whatsapp.model.media.MediaVisibilitySpec.encode(protoInputObject.mediaVisibility()));
outputStream.writeUInt64(28, protoInputObject.tokenSenderTimestampSeconds());
outputStream.writeBool(29, protoInputObject.suspended());
outputStream.writeBool(30, protoInputObject.terminated());
outputStream.writeUInt64(31, protoInputObject.foundationTimestampSeconds());
var founder = protoInputObject.founder();
if(founder != null) {
var founder0 = founder.orElse(null);
if(founder0 != null) {
var founder1 = founder0.toProtobufValue();
if(founder1 != null) {
outputStream.writeString(32, founder1);
}
}
}
var description = protoInputObject.description();
if(description != null) {
var description0 = description.orElse(null);
if(description0 != null) {
outputStream.writeString(33, description0);
}
}
outputStream.writeBool(34, protoInputObject.support());
outputStream.writeBool(35, protoInputObject.parentGroup());
outputStream.writeBool(36, protoInputObject.defaultSubGroup());
var parentGroupJid = protoInputObject.parentGroupJid();
if(parentGroupJid != null) {
var parentGroupJid0 = parentGroupJid.orElse(null);
if(parentGroupJid0 != null) {
var parentGroupJid1 = parentGroupJid0.toProtobufValue();
if(parentGroupJid1 != null) {
outputStream.writeString(37, parentGroupJid1);
}
}
}
var displayName = protoInputObject.displayName();
if(displayName != null) {
var displayName0 = displayName.orElse(null);
if(displayName0 != null) {
outputStream.writeString(38, displayName0);
}
}
var phoneJid = protoInputObject.phoneJid();
if(phoneJid != null) {
var phoneJid0 = phoneJid.orElse(null);
if(phoneJid0 != null) {
var phoneJid1 = phoneJid0.toProtobufValue();
if(phoneJid1 != null) {
outputStream.writeString(39, phoneJid1);
}
}
}
outputStream.writeBool(40, protoInputObject.shareOwnPhoneNumber());
outputStream.writeBool(41, protoInputObject.pnhDuplicateLidThread());
var lidJid = protoInputObject.lidJid();
if(lidJid != null) {
var lidJid0 = lidJid.orElse(null);
if(lidJid0 != null) {
var lidJid1 = lidJid0.toProtobufValue();
if(lidJid1 != null) {
outputStream.writeString(42, lidJid1);
}
}
}
      return outputStream.toByteArray();
    }

    public static Chat decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid jid = null;
        it.auties.whatsapp.util.ConcurrentLinkedHashedDequeue<it.auties.whatsapp.model.sync.HistorySyncMessage> historySyncMessages = new it.auties.whatsapp.util.ConcurrentLinkedHashedDequeue<it.auties.whatsapp.model.sync.HistorySyncMessage>();
        it.auties.whatsapp.model.jid.Jid newJid = null;
        it.auties.whatsapp.model.jid.Jid oldJid = null;
        int unreadMessagesCount = 0;
        boolean readOnly = false;
        boolean endOfHistoryTransfer = false;
        it.auties.whatsapp.model.chat.ChatEphemeralTimer ephemeralMessageDuration = null;
        long ephemeralMessagesToggleTimeSeconds = 0l;
        it.auties.whatsapp.model.chat.Chat.EndOfHistoryTransferType endOfHistoryTransferType = null;
        long timestampSeconds = 0l;
        java.lang.String name = null;
        boolean notSpam = false;
        boolean archived = false;
        it.auties.whatsapp.model.chat.ChatDisappear disappearInitiator = null;
        boolean markedAsUnread = false;
        java.util.List<it.auties.whatsapp.model.chat.GroupParticipant> participants = new java.util.ArrayList<it.auties.whatsapp.model.chat.GroupParticipant>();
        byte[] token = null;
        long tokenTimestampSeconds = 0l;
        byte[] identityKey = null;
        int pinnedTimestampSeconds = 0;
        it.auties.whatsapp.model.chat.ChatMute mute = null;
        it.auties.whatsapp.model.chat.ChatWallpaper wallpaper = null;
        it.auties.whatsapp.model.media.MediaVisibility mediaVisibility = null;
        long tokenSenderTimestampSeconds = 0l;
        boolean suspended = false;
        boolean terminated = false;
        long foundationTimestampSeconds = 0l;
        it.auties.whatsapp.model.jid.Jid founder = null;
        java.lang.String description = null;
        boolean support = false;
        boolean parentGroup = false;
        boolean defaultSubGroup = false;
        it.auties.whatsapp.model.jid.Jid parentGroupJid = null;
        java.lang.String displayName = null;
        it.auties.whatsapp.model.jid.Jid phoneJid = null;
        boolean shareOwnPhoneNumber = false;
        boolean pnhDuplicateLidThread = false;
        it.auties.whatsapp.model.jid.Jid lidJid = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> jid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> historySyncMessages.add(it.auties.whatsapp.model.sync.HistorySyncMessageSpec.decode(inputStream.readBytes()));
                case 3 -> newJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 4 -> oldJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 6 -> unreadMessagesCount = inputStream.readInt32();
                case 7 -> readOnly = inputStream.readBool();
                case 8 -> endOfHistoryTransfer = inputStream.readBool();
                case 9 -> ephemeralMessageDuration = it.auties.whatsapp.model.chat.ChatEphemeralTimer.of(inputStream.readInt32());
                case 10 -> ephemeralMessagesToggleTimeSeconds = inputStream.readInt64();
                case 11 -> endOfHistoryTransferType = it.auties.whatsapp.model.chat.ChatEndOfHistoryTransferTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 12 -> timestampSeconds = inputStream.readInt64();
                case 13 -> name = inputStream.readString();
                case 15 -> notSpam = inputStream.readBool();
                case 16 -> archived = inputStream.readBool();
                case 17 -> disappearInitiator = it.auties.whatsapp.model.chat.ChatDisappearSpec.decode(inputStream.readBytes());
                case 19 -> markedAsUnread = inputStream.readBool();
                case 20 -> participants.add(it.auties.whatsapp.model.chat.GroupParticipantSpec.decode(inputStream.readBytes()));
                case 21 -> token = inputStream.readBytes();
                case 22 -> tokenTimestampSeconds = inputStream.readInt64();
                case 23 -> identityKey = inputStream.readBytes();
                case 24 -> pinnedTimestampSeconds = inputStream.readInt32();
                case 25 -> mute = it.auties.whatsapp.model.chat.ChatMute.ofProtobuf(inputStream.readInt64());
                case 26 -> wallpaper = it.auties.whatsapp.model.chat.ChatWallpaperSpec.decode(inputStream.readBytes());
                case 27 -> mediaVisibility = it.auties.whatsapp.model.media.MediaVisibilitySpec.decode(inputStream.readInt32()).orElse(null);
                case 28 -> tokenSenderTimestampSeconds = inputStream.readInt64();
                case 29 -> suspended = inputStream.readBool();
                case 30 -> terminated = inputStream.readBool();
                case 31 -> foundationTimestampSeconds = inputStream.readInt64();
                case 32 -> founder = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 33 -> description = inputStream.readString();
                case 34 -> support = inputStream.readBool();
                case 35 -> parentGroup = inputStream.readBool();
                case 36 -> defaultSubGroup = inputStream.readBool();
                case 37 -> parentGroupJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 38 -> displayName = inputStream.readString();
                case 39 -> phoneJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 40 -> shareOwnPhoneNumber = inputStream.readBool();
                case 41 -> pnhDuplicateLidThread = inputStream.readBool();
                case 42 -> lidJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.chat.Chat(jid, historySyncMessages, newJid, oldJid, unreadMessagesCount, readOnly, endOfHistoryTransfer, ephemeralMessageDuration, ephemeralMessagesToggleTimeSeconds, endOfHistoryTransferType, timestampSeconds, name, notSpam, archived, disappearInitiator, markedAsUnread, participants, token, tokenTimestampSeconds, identityKey, pinnedTimestampSeconds, mute, wallpaper, mediaVisibility, tokenSenderTimestampSeconds, suspended, terminated, foundationTimestampSeconds, founder, description, support, parentGroup, defaultSubGroup, parentGroupJid, displayName, phoneJid, shareOwnPhoneNumber, pnhDuplicateLidThread, lidJid);
    }

}
