package it.auties.whatsapp.model.chat;

import it.auties.whatsapp.model.chat.ChatWallpaper;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ChatWallpaperSpec {
    public static byte[] encode(ChatWallpaper protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.filename());
outputStream.writeUInt32(2, protoInputObject.opacity());
      return outputStream.toByteArray();
    }

    public static ChatWallpaper decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String filename = null;
        int opacity = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> filename = inputStream.readString();
                case 2 -> opacity = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.chat.ChatWallpaper(filename, opacity);
    }

}
