package it.auties.whatsapp.model.chat;

import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class GroupParticipantSpec {
    public static byte[] encode(GroupParticipant protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var jid = protoInputObject.jid();
if(jid != null) {
var jid0 = jid.toProtobufValue();
if(jid0 != null) {
outputStream.writeString(1, jid0);
}
}
outputStream.writeInt32(2, it.auties.whatsapp.model.chat.GroupRoleSpec.encode(protoInputObject.role()));
      return outputStream.toByteArray();
    }

    public static GroupParticipant decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid jid = null;
        it.auties.whatsapp.model.chat.GroupRole role = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> jid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> role = it.auties.whatsapp.model.chat.GroupRoleSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.chat.GroupParticipant(jid, role);
    }

}
