package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.AdReplyInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AdReplyInfoSpec {
    public static byte[] encode(AdReplyInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.advertiserName());
outputStream.writeInt32(2, it.auties.whatsapp.model.info.AdReplyInfoMediaTypeSpec.encode(protoInputObject.mediaType()));
var thumbnail = protoInputObject.thumbnail();
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(16, thumbnail0);
}
var caption = protoInputObject.caption();
var caption0 = caption.orElse(null);
if(caption0 != null) {
outputStream.writeString(17, caption0);
}
      return outputStream.toByteArray();
    }

    public static AdReplyInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String advertiserName = null;
        it.auties.whatsapp.model.info.AdReplyInfo.MediaType mediaType = null;
        java.util.Optional<byte[]> thumbnail = java.util.Optional.empty();
        java.util.Optional<java.lang.String> caption = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> advertiserName = inputStream.readString();
                case 2 -> mediaType = it.auties.whatsapp.model.info.AdReplyInfoMediaTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 16 -> thumbnail = java.util.Optional.ofNullable(inputStream.readBytes());
                case 17 -> caption = java.util.Optional.ofNullable(inputStream.readString());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.AdReplyInfo(advertiserName, mediaType, thumbnail, caption);
    }

}
