package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.BusinessAccountLinkInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class BusinessAccountLinkInfoSpec {
    public static byte[] encode(BusinessAccountLinkInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt64(1, protoInputObject.businessId());
outputStream.writeString(2, protoInputObject.phoneNumber());
outputStream.writeUInt64(3, protoInputObject.issueTimeSeconds());
outputStream.writeInt32(4, it.auties.whatsapp.model.info.BusinessAccountLinkInfoHostStorageTypeSpec.encode(protoInputObject.hostStorage()));
outputStream.writeInt32(5, it.auties.whatsapp.model.info.BusinessAccountLinkInfoAccountTypeSpec.encode(protoInputObject.accountType()));
      return outputStream.toByteArray();
    }

    public static BusinessAccountLinkInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        long businessId = 0l;
        java.lang.String phoneNumber = null;
        long issueTimeSeconds = 0l;
        it.auties.whatsapp.model.info.BusinessAccountLinkInfo.HostStorageType hostStorage = null;
        it.auties.whatsapp.model.info.BusinessAccountLinkInfo.AccountType accountType = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> businessId = inputStream.readInt64();
                case 2 -> phoneNumber = inputStream.readString();
                case 3 -> issueTimeSeconds = inputStream.readInt64();
                case 4 -> hostStorage = it.auties.whatsapp.model.info.BusinessAccountLinkInfoHostStorageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 5 -> accountType = it.auties.whatsapp.model.info.BusinessAccountLinkInfoAccountTypeSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.BusinessAccountLinkInfo(businessId, phoneNumber, issueTimeSeconds, hostStorage, accountType);
    }

}
