package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.BusinessIdentityInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class BusinessIdentityInfoSpec {
    public static byte[] encode(BusinessIdentityInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.info.BusinessIdentityInfoVerifiedLevelSpec.encode(protoInputObject.level()));
outputStream.writeBytes(2, it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec.encode(protoInputObject.certificate()));
outputStream.writeBool(3, protoInputObject.signed());
outputStream.writeBool(4, protoInputObject.revoked());
outputStream.writeInt32(5, it.auties.whatsapp.model.info.BusinessIdentityInfoHostStorageTypeSpec.encode(protoInputObject.hostStorage()));
outputStream.writeInt32(6, it.auties.whatsapp.model.info.BusinessIdentityInfoActorsTypeSpec.encode(protoInputObject.actualActors()));
outputStream.writeUInt64(7, protoInputObject.privacyModeTimestampSeconds());
outputStream.writeUInt64(8, protoInputObject.featureControls());
      return outputStream.toByteArray();
    }

    public static BusinessIdentityInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.info.BusinessIdentityInfo.VerifiedLevel level = null;
        it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate certificate = null;
        boolean signed = false;
        boolean revoked = false;
        it.auties.whatsapp.model.info.BusinessIdentityInfo.HostStorageType hostStorage = null;
        it.auties.whatsapp.model.info.BusinessIdentityInfo.ActorsType actualActors = null;
        long privacyModeTimestampSeconds = 0l;
        long featureControls = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> level = it.auties.whatsapp.model.info.BusinessIdentityInfoVerifiedLevelSpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> certificate = it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec.decode(inputStream.readBytes());
                case 3 -> signed = inputStream.readBool();
                case 4 -> revoked = inputStream.readBool();
                case 5 -> hostStorage = it.auties.whatsapp.model.info.BusinessIdentityInfoHostStorageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 6 -> actualActors = it.auties.whatsapp.model.info.BusinessIdentityInfoActorsTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 7 -> privacyModeTimestampSeconds = inputStream.readInt64();
                case 8 -> featureControls = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.BusinessIdentityInfo(level, certificate, signed, revoked, hostStorage, actualActors, privacyModeTimestampSeconds, featureControls);
    }

}
