package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.DeviceContextInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DeviceContextInfoSpec {
    public static byte[] encode(DeviceContextInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var deviceListMetadata = protoInputObject.deviceListMetadata();
if(deviceListMetadata != null) {
var deviceListMetadata0 = deviceListMetadata.orElse(null);
if(deviceListMetadata0 != null) {
outputStream.writeBytes(1, it.auties.whatsapp.model.sync.DeviceListMetadataSpec.encode(deviceListMetadata0));
}
}
outputStream.writeInt32(2, protoInputObject.deviceListMetadataVersion());
var messageSecret = protoInputObject.messageSecret();
if(messageSecret != null) {
var messageSecret0 = messageSecret.orElse(null);
if(messageSecret0 != null) {
outputStream.writeBytes(3, messageSecret0);
}
}
var paddingBytes = protoInputObject.paddingBytes();
if(paddingBytes != null) {
var paddingBytes0 = paddingBytes.orElse(null);
if(paddingBytes0 != null) {
outputStream.writeBytes(4, paddingBytes0);
}
}
      return outputStream.toByteArray();
    }

    public static DeviceContextInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.sync.DeviceListMetadata deviceListMetadata = null;
        int deviceListMetadataVersion = 0;
        byte[] messageSecret = null;
        byte[] paddingBytes = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> deviceListMetadata = it.auties.whatsapp.model.sync.DeviceListMetadataSpec.decode(inputStream.readBytes());
                case 2 -> deviceListMetadataVersion = inputStream.readInt32();
                case 3 -> messageSecret = inputStream.readBytes();
                case 4 -> paddingBytes = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.DeviceContextInfo(deviceListMetadata, deviceListMetadataVersion, messageSecret, paddingBytes);
    }

}
