package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.ExternalAdReplyInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ExternalAdReplyInfoSpec {
    public static byte[] encode(ExternalAdReplyInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var title = protoInputObject.title();
var title0 = title.orElse(null);
if(title0 != null) {
outputStream.writeString(1, title0);
}
var body = protoInputObject.body();
var body0 = body.orElse(null);
if(body0 != null) {
outputStream.writeString(2, body0);
}
var mediaType = protoInputObject.mediaType();
var mediaType0 = mediaType.orElse(null);
if(mediaType0 != null) {
outputStream.writeInt32(3, it.auties.whatsapp.model.info.ExternalAdReplyInfoMediaTypeSpec.encode(mediaType0));
}
var thumbnailUrl = protoInputObject.thumbnailUrl();
var thumbnailUrl0 = thumbnailUrl.orElse(null);
if(thumbnailUrl0 != null) {
outputStream.writeString(4, thumbnailUrl0);
}
var mediaUrl = protoInputObject.mediaUrl();
var mediaUrl0 = mediaUrl.orElse(null);
if(mediaUrl0 != null) {
outputStream.writeString(5, mediaUrl0);
}
var thumbnail = protoInputObject.thumbnail();
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(6, thumbnail0);
}
var sourceType = protoInputObject.sourceType();
var sourceType0 = sourceType.orElse(null);
if(sourceType0 != null) {
outputStream.writeString(7, sourceType0);
}
var sourceId = protoInputObject.sourceId();
var sourceId0 = sourceId.orElse(null);
if(sourceId0 != null) {
outputStream.writeString(8, sourceId0);
}
var sourceUrl = protoInputObject.sourceUrl();
var sourceUrl0 = sourceUrl.orElse(null);
if(sourceUrl0 != null) {
outputStream.writeString(9, sourceUrl0);
}
outputStream.writeBool(10, protoInputObject.containsAutoReply());
outputStream.writeBool(11, protoInputObject.renderLargerThumbnail());
outputStream.writeBool(12, protoInputObject.showAdAttribution());
var ctwaClid = protoInputObject.ctwaClid();
var ctwaClid0 = ctwaClid.orElse(null);
if(ctwaClid0 != null) {
outputStream.writeString(13, ctwaClid0);
}
      return outputStream.toByteArray();
    }

    public static ExternalAdReplyInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.Optional<java.lang.String> title = java.util.Optional.empty();
        java.util.Optional<java.lang.String> body = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.info.ExternalAdReplyInfo.MediaType> mediaType = java.util.Optional.empty();
        java.util.Optional<java.lang.String> thumbnailUrl = java.util.Optional.empty();
        java.util.Optional<java.lang.String> mediaUrl = java.util.Optional.empty();
        java.util.Optional<byte[]> thumbnail = java.util.Optional.empty();
        java.util.Optional<java.lang.String> sourceType = java.util.Optional.empty();
        java.util.Optional<java.lang.String> sourceId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> sourceUrl = java.util.Optional.empty();
        boolean containsAutoReply = false;
        boolean renderLargerThumbnail = false;
        boolean showAdAttribution = false;
        java.util.Optional<java.lang.String> ctwaClid = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> title = java.util.Optional.ofNullable(inputStream.readString());
                case 2 -> body = java.util.Optional.ofNullable(inputStream.readString());
                case 3 -> mediaType = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.ExternalAdReplyInfoMediaTypeSpec.decode(inputStream.readInt32()).orElse(null));
                case 4 -> thumbnailUrl = java.util.Optional.ofNullable(inputStream.readString());
                case 5 -> mediaUrl = java.util.Optional.ofNullable(inputStream.readString());
                case 6 -> thumbnail = java.util.Optional.ofNullable(inputStream.readBytes());
                case 7 -> sourceType = java.util.Optional.ofNullable(inputStream.readString());
                case 8 -> sourceId = java.util.Optional.ofNullable(inputStream.readString());
                case 9 -> sourceUrl = java.util.Optional.ofNullable(inputStream.readString());
                case 10 -> containsAutoReply = inputStream.readBool();
                case 11 -> renderLargerThumbnail = inputStream.readBool();
                case 12 -> showAdAttribution = inputStream.readBool();
                case 13 -> ctwaClid = java.util.Optional.ofNullable(inputStream.readString());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.ExternalAdReplyInfo(title, body, mediaType, thumbnailUrl, mediaUrl, thumbnail, sourceType, sourceId, sourceUrl, containsAutoReply, renderLargerThumbnail, showAdAttribution, ctwaClid);
    }

}
