package it.auties.whatsapp.model.info;

import it.auties.whatsapp.model.info.PaymentInfo;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PaymentInfoSpec {
    public static byte[] encode(PaymentInfo protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.info.PaymentInfoCurrencySpec.encode(protoInputObject.currencyDeprecated()));
outputStream.writeUInt64(2, protoInputObject.amount1000());
var receiverJid = protoInputObject.receiverJid();
if(receiverJid != null) {
var receiverJid0 = receiverJid.toProtobufValue();
if(receiverJid0 != null) {
outputStream.writeString(3, receiverJid0);
}
}
outputStream.writeInt32(4, it.auties.whatsapp.model.info.PaymentInfoStatusSpec.encode(protoInputObject.status()));
outputStream.writeUInt64(5, protoInputObject.transactionTimestampSeconds());
outputStream.writeBytes(6, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.requestMessageKey()));
outputStream.writeUInt64(7, protoInputObject.expiryTimestampSeconds());
outputStream.writeBool(8, protoInputObject.futureProofed());
outputStream.writeString(9, protoInputObject.currency());
outputStream.writeInt32(10, it.auties.whatsapp.model.info.PaymentInfoTransactionStatusSpec.encode(protoInputObject.transactionStatus()));
outputStream.writeBool(11, protoInputObject.useNoviFormat());
outputStream.writeBytes(12, it.auties.whatsapp.model.payment.PaymentMoneySpec.encode(protoInputObject.primaryAmount()));
outputStream.writeBytes(13, it.auties.whatsapp.model.payment.PaymentMoneySpec.encode(protoInputObject.exchangeAmount()));
      return outputStream.toByteArray();
    }

    public static PaymentInfo decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.info.PaymentInfo.Currency currencyDeprecated = null;
        long amount1000 = 0l;
        it.auties.whatsapp.model.jid.Jid receiverJid = null;
        it.auties.whatsapp.model.info.PaymentInfo.Status status = null;
        long transactionTimestampSeconds = 0l;
        it.auties.whatsapp.model.message.model.ChatMessageKey requestMessageKey = null;
        long expiryTimestampSeconds = 0l;
        boolean futureProofed = false;
        java.lang.String currency = null;
        it.auties.whatsapp.model.info.PaymentInfo.TransactionStatus transactionStatus = null;
        boolean useNoviFormat = false;
        it.auties.whatsapp.model.payment.PaymentMoney primaryAmount = null;
        it.auties.whatsapp.model.payment.PaymentMoney exchangeAmount = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> currencyDeprecated = it.auties.whatsapp.model.info.PaymentInfoCurrencySpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> amount1000 = inputStream.readInt64();
                case 3 -> receiverJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 4 -> status = it.auties.whatsapp.model.info.PaymentInfoStatusSpec.decode(inputStream.readInt32()).orElse(null);
                case 5 -> transactionTimestampSeconds = inputStream.readInt64();
                case 6 -> requestMessageKey = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 7 -> expiryTimestampSeconds = inputStream.readInt64();
                case 8 -> futureProofed = inputStream.readBool();
                case 9 -> currency = inputStream.readString();
                case 10 -> transactionStatus = it.auties.whatsapp.model.info.PaymentInfoTransactionStatusSpec.decode(inputStream.readInt32()).orElse(null);
                case 11 -> useNoviFormat = inputStream.readBool();
                case 12 -> primaryAmount = it.auties.whatsapp.model.payment.PaymentMoneySpec.decode(inputStream.readBytes());
                case 13 -> exchangeAmount = it.auties.whatsapp.model.payment.PaymentMoneySpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.info.PaymentInfo(currencyDeprecated, amount1000, receiverJid, status, transactionTimestampSeconds, requestMessageKey, expiryTimestampSeconds, futureProofed, currency, transactionStatus, useNoviFormat, primaryAmount, exchangeAmount);
    }

}
