package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.message.button.ButtonsMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ButtonsMessageSpec {
    public static byte[] encode(ButtonsMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var headerText = protoInputObject.headerText();
var headerText0 = headerText.orElse(null);
if(headerText0 != null) {
var headerText1 = headerText0.text();
if(headerText1 != null) {
outputStream.writeString(1, headerText1);
}
}
var headerDocument = protoInputObject.headerDocument();
var headerDocument0 = headerDocument.orElse(null);
if(headerDocument0 != null) {
outputStream.writeBytes(2, it.auties.whatsapp.model.message.standard.DocumentMessageSpec.encode(headerDocument0));
}
var headerImage = protoInputObject.headerImage();
var headerImage0 = headerImage.orElse(null);
if(headerImage0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.message.standard.ImageMessageSpec.encode(headerImage0));
}
var headerVideo = protoInputObject.headerVideo();
var headerVideo0 = headerVideo.orElse(null);
if(headerVideo0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec.encode(headerVideo0));
}
var headerLocation = protoInputObject.headerLocation();
var headerLocation0 = headerLocation.orElse(null);
if(headerLocation0 != null) {
outputStream.writeBytes(5, it.auties.whatsapp.model.message.standard.LocationMessageSpec.encode(headerLocation0));
}
var body = protoInputObject.body();
var body0 = body.orElse(null);
if(body0 != null) {
outputStream.writeString(6, body0);
}
var footer = protoInputObject.footer();
var footer0 = footer.orElse(null);
if(footer0 != null) {
outputStream.writeString(7, footer0);
}
var contextInfo = protoInputObject.contextInfo();
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(8, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
      if(protoInputObject.buttons() != null) {
       for(var buttonsEntry : protoInputObject.buttons()) {
outputStream.writeBytes(9, it.auties.whatsapp.model.button.base.ButtonSpec.encode(buttonsEntry));
       }
      }
outputStream.writeInt32(10, it.auties.whatsapp.model.message.button.ButtonsMessageHeaderTypeSpec.encode(protoInputObject.headerType()));
      return outputStream.toByteArray();
    }

    public static ButtonsMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.Optional<it.auties.whatsapp.model.message.button.ButtonsMessageHeaderText> headerText = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.DocumentMessage> headerDocument = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.ImageMessage> headerImage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.VideoOrGifMessage> headerVideo = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.LocationMessage> headerLocation = java.util.Optional.empty();
        java.util.Optional<java.lang.String> body = java.util.Optional.empty();
        java.util.Optional<java.lang.String> footer = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo = java.util.Optional.empty();
        java.util.List<it.auties.whatsapp.model.button.base.Button> buttons = new java.util.ArrayList<it.auties.whatsapp.model.button.base.Button>();
        it.auties.whatsapp.model.message.button.ButtonsMessageHeader.Type headerType = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> headerText = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.ButtonsMessageHeaderText.of(inputStream.readString()));
                case 2 -> headerDocument = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.DocumentMessageSpec.decode(inputStream.readBytes()));
                case 3 -> headerImage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.ImageMessageSpec.decode(inputStream.readBytes()));
                case 4 -> headerVideo = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec.decode(inputStream.readBytes()));
                case 5 -> headerLocation = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.LocationMessageSpec.decode(inputStream.readBytes()));
                case 6 -> body = java.util.Optional.ofNullable(inputStream.readString());
                case 7 -> footer = java.util.Optional.ofNullable(inputStream.readString());
                case 8 -> contextInfo = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes()));
                case 9 -> buttons.add(it.auties.whatsapp.model.button.base.ButtonSpec.decode(inputStream.readBytes()));
                case 10 -> headerType = it.auties.whatsapp.model.message.button.ButtonsMessageHeaderTypeSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.button.ButtonsMessage(headerText, headerDocument, headerImage, headerVideo, headerLocation, body, footer, contextInfo, buttons, headerType);
    }

}
