package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.message.button.ButtonsResponseMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ButtonsResponseMessageSpec {
    public static byte[] encode(ButtonsResponseMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.buttonId());
var buttonText = protoInputObject.buttonText();
var buttonText0 = buttonText.orElse(null);
if(buttonText0 != null) {
outputStream.writeString(2, buttonText0);
}
var contextInfo = protoInputObject.contextInfo();
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
outputStream.writeInt32(4, it.auties.whatsapp.model.message.button.ButtonsResponseMessageResponseTypeSpec.encode(protoInputObject.responseType()));
      return outputStream.toByteArray();
    }

    public static ButtonsResponseMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String buttonId = null;
        java.util.Optional<java.lang.String> buttonText = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo = java.util.Optional.empty();
        it.auties.whatsapp.model.message.button.ButtonsResponseMessage.ResponseType responseType = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> buttonId = inputStream.readString();
                case 2 -> buttonText = java.util.Optional.ofNullable(inputStream.readString());
                case 3 -> contextInfo = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes()));
                case 4 -> responseType = it.auties.whatsapp.model.message.button.ButtonsResponseMessageResponseTypeSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.button.ButtonsResponseMessage(buttonId, buttonText, contextInfo, responseType);
    }

}
