package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.message.button.ListResponseMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ListResponseMessageSpec {
    public static byte[] encode(ListResponseMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.title());
outputStream.writeBytes(3, it.auties.whatsapp.model.button.misc.SingleSelectReplyButtonSpec.encode(protoInputObject.reply()));
var contextInfo = protoInputObject.contextInfo();
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
var description = protoInputObject.description();
var description0 = description.orElse(null);
if(description0 != null) {
outputStream.writeString(5, description0);
}
outputStream.writeInt32(2, it.auties.whatsapp.model.message.button.ListResponseMessageTypeSpec.encode(protoInputObject.listType()));
      return outputStream.toByteArray();
    }

    public static ListResponseMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String title = null;
        it.auties.whatsapp.model.button.misc.SingleSelectReplyButton reply = null;
        java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo = java.util.Optional.empty();
        java.util.Optional<java.lang.String> description = java.util.Optional.empty();
        it.auties.whatsapp.model.message.button.ListResponseMessage.Type listType = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> title = inputStream.readString();
                case 3 -> reply = it.auties.whatsapp.model.button.misc.SingleSelectReplyButtonSpec.decode(inputStream.readBytes());
                case 4 -> contextInfo = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes()));
                case 5 -> description = java.util.Optional.ofNullable(inputStream.readString());
                case 2 -> listType = it.auties.whatsapp.model.message.button.ListResponseMessageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.button.ListResponseMessage(title, reply, contextInfo, description, listType);
    }

}
