package it.auties.whatsapp.model.message.button;

import it.auties.whatsapp.model.message.button.TemplateReplyMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class TemplateReplyMessageSpec {
    public static byte[] encode(TemplateReplyMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
outputStream.writeString(2, protoInputObject.buttonText());
var contextInfo = protoInputObject.contextInfo();
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
outputStream.writeUInt32(4, protoInputObject.index());
      return outputStream.toByteArray();
    }

    public static TemplateReplyMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        java.lang.String buttonText = null;
        java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo = java.util.Optional.empty();
        int index = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> buttonText = inputStream.readString();
                case 3 -> contextInfo = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes()));
                case 4 -> index = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.button.TemplateReplyMessage(id, buttonText, contextInfo, index);
    }

}
