package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ChatMessageKeySpec {
    public static byte[] encode(ChatMessageKey protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var chatJid = protoInputObject.chatJid();
if(chatJid != null) {
var chatJid0 = chatJid.toProtobufValue();
if(chatJid0 != null) {
outputStream.writeString(1, chatJid0);
}
}
outputStream.writeBool(2, protoInputObject.fromMe());
outputStream.writeString(3, protoInputObject.id());
var senderJid = protoInputObject.senderJid();
if(senderJid != null) {
var senderJid0 = senderJid.orElse(null);
if(senderJid0 != null) {
var senderJid1 = senderJid0.toProtobufValue();
if(senderJid1 != null) {
outputStream.writeString(4, senderJid1);
}
}
}
      return outputStream.toByteArray();
    }

    public static ChatMessageKey decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid chatJid = null;
        boolean fromMe = false;
        java.lang.String id = null;
        it.auties.whatsapp.model.jid.Jid senderJid = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> chatJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> fromMe = inputStream.readBool();
                case 3 -> id = inputStream.readString();
                case 4 -> senderJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.model.ChatMessageKey(chatJid, fromMe, id, senderJid);
    }

}
