package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class MessageContainerSpec {
    public static byte[] encode(MessageContainer protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var textWithNoContextMessage = protoInputObject.textWithNoContextMessage();
var textWithNoContextMessage0 = textWithNoContextMessage.orElse(null);
if(textWithNoContextMessage0 != null) {
outputStream.writeString(1, textWithNoContextMessage0);
}
var senderKeyDistributionMessage = protoInputObject.senderKeyDistributionMessage();
var senderKeyDistributionMessage0 = senderKeyDistributionMessage.orElse(null);
if(senderKeyDistributionMessage0 != null) {
outputStream.writeBytes(2, it.auties.whatsapp.model.message.server.SenderKeyDistributionMessageSpec.encode(senderKeyDistributionMessage0));
}
var imageMessage = protoInputObject.imageMessage();
var imageMessage0 = imageMessage.orElse(null);
if(imageMessage0 != null) {
outputStream.writeBytes(3, it.auties.whatsapp.model.message.standard.ImageMessageSpec.encode(imageMessage0));
}
var contactMessage = protoInputObject.contactMessage();
var contactMessage0 = contactMessage.orElse(null);
if(contactMessage0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.message.standard.ContactMessageSpec.encode(contactMessage0));
}
var locationMessage = protoInputObject.locationMessage();
var locationMessage0 = locationMessage.orElse(null);
if(locationMessage0 != null) {
outputStream.writeBytes(5, it.auties.whatsapp.model.message.standard.LocationMessageSpec.encode(locationMessage0));
}
var textMessage = protoInputObject.textMessage();
var textMessage0 = textMessage.orElse(null);
if(textMessage0 != null) {
outputStream.writeBytes(6, it.auties.whatsapp.model.message.standard.TextMessageSpec.encode(textMessage0));
}
var documentMessage = protoInputObject.documentMessage();
var documentMessage0 = documentMessage.orElse(null);
if(documentMessage0 != null) {
outputStream.writeBytes(7, it.auties.whatsapp.model.message.standard.DocumentMessageSpec.encode(documentMessage0));
}
var audioMessage = protoInputObject.audioMessage();
var audioMessage0 = audioMessage.orElse(null);
if(audioMessage0 != null) {
outputStream.writeBytes(8, it.auties.whatsapp.model.message.standard.AudioMessageSpec.encode(audioMessage0));
}
var videoMessage = protoInputObject.videoMessage();
var videoMessage0 = videoMessage.orElse(null);
if(videoMessage0 != null) {
outputStream.writeBytes(9, it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec.encode(videoMessage0));
}
var callMessage = protoInputObject.callMessage();
var callMessage0 = callMessage.orElse(null);
if(callMessage0 != null) {
outputStream.writeBytes(10, it.auties.whatsapp.model.message.standard.CallMessageSpec.encode(callMessage0));
}
var protocolMessage = protoInputObject.protocolMessage();
var protocolMessage0 = protocolMessage.orElse(null);
if(protocolMessage0 != null) {
outputStream.writeBytes(12, it.auties.whatsapp.model.message.server.ProtocolMessageSpec.encode(protocolMessage0));
}
var contactsArrayMessage = protoInputObject.contactsArrayMessage();
var contactsArrayMessage0 = contactsArrayMessage.orElse(null);
if(contactsArrayMessage0 != null) {
outputStream.writeBytes(13, it.auties.whatsapp.model.message.standard.ContactsMessageSpec.encode(contactsArrayMessage0));
}
var highlyStructuredMessage = protoInputObject.highlyStructuredMessage();
var highlyStructuredMessage0 = highlyStructuredMessage.orElse(null);
if(highlyStructuredMessage0 != null) {
outputStream.writeBytes(14, it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessageSpec.encode(highlyStructuredMessage0));
}
var sendPaymentMessage = protoInputObject.sendPaymentMessage();
var sendPaymentMessage0 = sendPaymentMessage.orElse(null);
if(sendPaymentMessage0 != null) {
outputStream.writeBytes(16, it.auties.whatsapp.model.message.payment.SendPaymentMessageSpec.encode(sendPaymentMessage0));
}
var liveLocationMessage = protoInputObject.liveLocationMessage();
var liveLocationMessage0 = liveLocationMessage.orElse(null);
if(liveLocationMessage0 != null) {
outputStream.writeBytes(18, it.auties.whatsapp.model.message.standard.LiveLocationMessageSpec.encode(liveLocationMessage0));
}
var requestPaymentMessage = protoInputObject.requestPaymentMessage();
var requestPaymentMessage0 = requestPaymentMessage.orElse(null);
if(requestPaymentMessage0 != null) {
outputStream.writeBytes(22, it.auties.whatsapp.model.message.payment.RequestPaymentMessageSpec.encode(requestPaymentMessage0));
}
var declinePaymentRequestMessage = protoInputObject.declinePaymentRequestMessage();
var declinePaymentRequestMessage0 = declinePaymentRequestMessage.orElse(null);
if(declinePaymentRequestMessage0 != null) {
outputStream.writeBytes(23, it.auties.whatsapp.model.message.payment.DeclinePaymentRequestMessageSpec.encode(declinePaymentRequestMessage0));
}
var cancelPaymentRequestMessage = protoInputObject.cancelPaymentRequestMessage();
var cancelPaymentRequestMessage0 = cancelPaymentRequestMessage.orElse(null);
if(cancelPaymentRequestMessage0 != null) {
outputStream.writeBytes(24, it.auties.whatsapp.model.message.payment.CancelPaymentRequestMessageSpec.encode(cancelPaymentRequestMessage0));
}
var templateMessage = protoInputObject.templateMessage();
var templateMessage0 = templateMessage.orElse(null);
if(templateMessage0 != null) {
outputStream.writeBytes(25, it.auties.whatsapp.model.message.button.TemplateMessageSpec.encode(templateMessage0));
}
var stickerMessage = protoInputObject.stickerMessage();
var stickerMessage0 = stickerMessage.orElse(null);
if(stickerMessage0 != null) {
outputStream.writeBytes(26, it.auties.whatsapp.model.message.standard.StickerMessageSpec.encode(stickerMessage0));
}
var groupInviteMessage = protoInputObject.groupInviteMessage();
var groupInviteMessage0 = groupInviteMessage.orElse(null);
if(groupInviteMessage0 != null) {
outputStream.writeBytes(28, it.auties.whatsapp.model.message.standard.GroupInviteMessageSpec.encode(groupInviteMessage0));
}
var templateReplyMessage = protoInputObject.templateReplyMessage();
var templateReplyMessage0 = templateReplyMessage.orElse(null);
if(templateReplyMessage0 != null) {
outputStream.writeBytes(29, it.auties.whatsapp.model.message.button.TemplateReplyMessageSpec.encode(templateReplyMessage0));
}
var productMessage = protoInputObject.productMessage();
var productMessage0 = productMessage.orElse(null);
if(productMessage0 != null) {
outputStream.writeBytes(30, it.auties.whatsapp.model.message.standard.ProductMessageSpec.encode(productMessage0));
}
var deviceSentMessage = protoInputObject.deviceSentMessage();
var deviceSentMessage0 = deviceSentMessage.orElse(null);
if(deviceSentMessage0 != null) {
outputStream.writeBytes(31, it.auties.whatsapp.model.message.server.DeviceSentMessageSpec.encode(deviceSentMessage0));
}
var deviceSyncMessage = protoInputObject.deviceSyncMessage();
var deviceSyncMessage0 = deviceSyncMessage.orElse(null);
if(deviceSyncMessage0 != null) {
outputStream.writeBytes(32, it.auties.whatsapp.model.message.server.DeviceSyncMessageSpec.encode(deviceSyncMessage0));
}
var listMessage = protoInputObject.listMessage();
var listMessage0 = listMessage.orElse(null);
if(listMessage0 != null) {
outputStream.writeBytes(36, it.auties.whatsapp.model.message.button.ListMessageSpec.encode(listMessage0));
}
var viewOnceMessage = protoInputObject.viewOnceMessage();
var viewOnceMessage0 = viewOnceMessage.orElse(null);
if(viewOnceMessage0 != null) {
outputStream.writeBytes(37, it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.encode(viewOnceMessage0));
}
var orderMessage = protoInputObject.orderMessage();
var orderMessage0 = orderMessage.orElse(null);
if(orderMessage0 != null) {
outputStream.writeBytes(38, it.auties.whatsapp.model.message.payment.PaymentOrderMessageSpec.encode(orderMessage0));
}
var listResponseMessage = protoInputObject.listResponseMessage();
var listResponseMessage0 = listResponseMessage.orElse(null);
if(listResponseMessage0 != null) {
outputStream.writeBytes(39, it.auties.whatsapp.model.message.button.ListResponseMessageSpec.encode(listResponseMessage0));
}
var ephemeralMessage = protoInputObject.ephemeralMessage();
var ephemeralMessage0 = ephemeralMessage.orElse(null);
if(ephemeralMessage0 != null) {
outputStream.writeBytes(40, it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.encode(ephemeralMessage0));
}
var invoiceMessage = protoInputObject.invoiceMessage();
var invoiceMessage0 = invoiceMessage.orElse(null);
if(invoiceMessage0 != null) {
outputStream.writeBytes(41, it.auties.whatsapp.model.message.payment.PaymentInvoiceMessageSpec.encode(invoiceMessage0));
}
var buttonsMessage = protoInputObject.buttonsMessage();
var buttonsMessage0 = buttonsMessage.orElse(null);
if(buttonsMessage0 != null) {
outputStream.writeBytes(42, it.auties.whatsapp.model.message.button.ButtonsMessageSpec.encode(buttonsMessage0));
}
var buttonsResponseMessage = protoInputObject.buttonsResponseMessage();
var buttonsResponseMessage0 = buttonsResponseMessage.orElse(null);
if(buttonsResponseMessage0 != null) {
outputStream.writeBytes(43, it.auties.whatsapp.model.message.button.ButtonsResponseMessageSpec.encode(buttonsResponseMessage0));
}
var paymentInviteMessage = protoInputObject.paymentInviteMessage();
var paymentInviteMessage0 = paymentInviteMessage.orElse(null);
if(paymentInviteMessage0 != null) {
outputStream.writeBytes(44, it.auties.whatsapp.model.message.payment.PaymentInviteMessageSpec.encode(paymentInviteMessage0));
}
var interactiveMessage = protoInputObject.interactiveMessage();
var interactiveMessage0 = interactiveMessage.orElse(null);
if(interactiveMessage0 != null) {
outputStream.writeBytes(45, it.auties.whatsapp.model.message.button.InteractiveMessageSpec.encode(interactiveMessage0));
}
var reactionMessage = protoInputObject.reactionMessage();
var reactionMessage0 = reactionMessage.orElse(null);
if(reactionMessage0 != null) {
outputStream.writeBytes(46, it.auties.whatsapp.model.message.standard.ReactionMessageSpec.encode(reactionMessage0));
}
var stickerSyncMessage = protoInputObject.stickerSyncMessage();
var stickerSyncMessage0 = stickerSyncMessage.orElse(null);
if(stickerSyncMessage0 != null) {
outputStream.writeBytes(47, it.auties.whatsapp.model.message.server.StickerSyncRMRMessageSpec.encode(stickerSyncMessage0));
}
var interactiveResponseMessage = protoInputObject.interactiveResponseMessage();
var interactiveResponseMessage0 = interactiveResponseMessage.orElse(null);
if(interactiveResponseMessage0 != null) {
outputStream.writeBytes(48, it.auties.whatsapp.model.message.button.InteractiveResponseMessageSpec.encode(interactiveResponseMessage0));
}
var pollCreationMessage = protoInputObject.pollCreationMessage();
var pollCreationMessage0 = pollCreationMessage.orElse(null);
if(pollCreationMessage0 != null) {
outputStream.writeBytes(49, it.auties.whatsapp.model.message.standard.PollCreationMessageSpec.encode(pollCreationMessage0));
}
var pollUpdateMessage = protoInputObject.pollUpdateMessage();
var pollUpdateMessage0 = pollUpdateMessage.orElse(null);
if(pollUpdateMessage0 != null) {
outputStream.writeBytes(50, it.auties.whatsapp.model.message.standard.PollUpdateMessageSpec.encode(pollUpdateMessage0));
}
var keepInChatMessage = protoInputObject.keepInChatMessage();
var keepInChatMessage0 = keepInChatMessage.orElse(null);
if(keepInChatMessage0 != null) {
outputStream.writeBytes(51, it.auties.whatsapp.model.message.standard.KeepInChatMessageSpec.encode(keepInChatMessage0));
}
var documentWithCaptionMessage = protoInputObject.documentWithCaptionMessage();
var documentWithCaptionMessage0 = documentWithCaptionMessage.orElse(null);
if(documentWithCaptionMessage0 != null) {
outputStream.writeBytes(53, it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.encode(documentWithCaptionMessage0));
}
var requestPhoneNumberMessage = protoInputObject.requestPhoneNumberMessage();
var requestPhoneNumberMessage0 = requestPhoneNumberMessage.orElse(null);
if(requestPhoneNumberMessage0 != null) {
outputStream.writeBytes(54, it.auties.whatsapp.model.message.standard.RequestPhoneNumberMessageSpec.encode(requestPhoneNumberMessage0));
}
var viewOnceV2Message = protoInputObject.viewOnceV2Message();
var viewOnceV2Message0 = viewOnceV2Message.orElse(null);
if(viewOnceV2Message0 != null) {
outputStream.writeBytes(55, it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.encode(viewOnceV2Message0));
}
var encryptedReactionMessage = protoInputObject.encryptedReactionMessage();
var encryptedReactionMessage0 = encryptedReactionMessage.orElse(null);
if(encryptedReactionMessage0 != null) {
outputStream.writeBytes(56, it.auties.whatsapp.model.message.standard.EncryptedReactionMessageSpec.encode(encryptedReactionMessage0));
}
var editedMessage = protoInputObject.editedMessage();
var editedMessage0 = editedMessage.orElse(null);
if(editedMessage0 != null) {
outputStream.writeBytes(58, it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.encode(editedMessage0));
}
var viewOnceV2ExtensionMessage = protoInputObject.viewOnceV2ExtensionMessage();
var viewOnceV2ExtensionMessage0 = viewOnceV2ExtensionMessage.orElse(null);
if(viewOnceV2ExtensionMessage0 != null) {
outputStream.writeBytes(59, it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.encode(viewOnceV2ExtensionMessage0));
}
var deviceInfo = protoInputObject.deviceInfo();
var deviceInfo0 = deviceInfo.orElse(null);
if(deviceInfo0 != null) {
outputStream.writeBytes(35, it.auties.whatsapp.model.info.DeviceContextInfoSpec.encode(deviceInfo0));
}
      return outputStream.toByteArray();
    }

    public static MessageContainer decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.Optional<java.lang.String> textWithNoContextMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.server.SenderKeyDistributionMessage> senderKeyDistributionMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.ImageMessage> imageMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.ContactMessage> contactMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.LocationMessage> locationMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.TextMessage> textMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.DocumentMessage> documentMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.AudioMessage> audioMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.VideoOrGifMessage> videoMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.CallMessage> callMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.server.ProtocolMessage> protocolMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.ContactsMessage> contactsArrayMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessage> highlyStructuredMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.payment.SendPaymentMessage> sendPaymentMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.LiveLocationMessage> liveLocationMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.payment.RequestPaymentMessage> requestPaymentMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.payment.DeclinePaymentRequestMessage> declinePaymentRequestMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.payment.CancelPaymentRequestMessage> cancelPaymentRequestMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.button.TemplateMessage> templateMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.StickerMessage> stickerMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.GroupInviteMessage> groupInviteMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.button.TemplateReplyMessage> templateReplyMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.ProductMessage> productMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.server.DeviceSentMessage> deviceSentMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.server.DeviceSyncMessage> deviceSyncMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.button.ListMessage> listMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.model.FutureMessageContainer> viewOnceMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.payment.PaymentOrderMessage> orderMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.button.ListResponseMessage> listResponseMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.model.FutureMessageContainer> ephemeralMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.payment.PaymentInvoiceMessage> invoiceMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.button.ButtonsMessage> buttonsMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.button.ButtonsResponseMessage> buttonsResponseMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.payment.PaymentInviteMessage> paymentInviteMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.button.InteractiveMessage> interactiveMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.ReactionMessage> reactionMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.server.StickerSyncRMRMessage> stickerSyncMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.button.InteractiveResponseMessage> interactiveResponseMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.PollCreationMessage> pollCreationMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.PollUpdateMessage> pollUpdateMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.KeepInChatMessage> keepInChatMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.model.FutureMessageContainer> documentWithCaptionMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.RequestPhoneNumberMessage> requestPhoneNumberMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.model.FutureMessageContainer> viewOnceV2Message = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.standard.EncryptedReactionMessage> encryptedReactionMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.model.FutureMessageContainer> editedMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.message.model.FutureMessageContainer> viewOnceV2ExtensionMessage = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.info.DeviceContextInfo> deviceInfo = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> textWithNoContextMessage = java.util.Optional.ofNullable(inputStream.readString());
                case 2 -> senderKeyDistributionMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.server.SenderKeyDistributionMessageSpec.decode(inputStream.readBytes()));
                case 3 -> imageMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.ImageMessageSpec.decode(inputStream.readBytes()));
                case 4 -> contactMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.ContactMessageSpec.decode(inputStream.readBytes()));
                case 5 -> locationMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.LocationMessageSpec.decode(inputStream.readBytes()));
                case 6 -> textMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.TextMessageSpec.decode(inputStream.readBytes()));
                case 7 -> documentMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.DocumentMessageSpec.decode(inputStream.readBytes()));
                case 8 -> audioMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.AudioMessageSpec.decode(inputStream.readBytes()));
                case 9 -> videoMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.VideoOrGifMessageSpec.decode(inputStream.readBytes()));
                case 10 -> callMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.CallMessageSpec.decode(inputStream.readBytes()));
                case 12 -> protocolMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.server.ProtocolMessageSpec.decode(inputStream.readBytes()));
                case 13 -> contactsArrayMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.ContactsMessageSpec.decode(inputStream.readBytes()));
                case 14 -> highlyStructuredMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.button.template.highlyStructured.HighlyStructuredMessageSpec.decode(inputStream.readBytes()));
                case 16 -> sendPaymentMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.payment.SendPaymentMessageSpec.decode(inputStream.readBytes()));
                case 18 -> liveLocationMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.LiveLocationMessageSpec.decode(inputStream.readBytes()));
                case 22 -> requestPaymentMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.payment.RequestPaymentMessageSpec.decode(inputStream.readBytes()));
                case 23 -> declinePaymentRequestMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.payment.DeclinePaymentRequestMessageSpec.decode(inputStream.readBytes()));
                case 24 -> cancelPaymentRequestMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.payment.CancelPaymentRequestMessageSpec.decode(inputStream.readBytes()));
                case 25 -> templateMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.TemplateMessageSpec.decode(inputStream.readBytes()));
                case 26 -> stickerMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.StickerMessageSpec.decode(inputStream.readBytes()));
                case 28 -> groupInviteMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.GroupInviteMessageSpec.decode(inputStream.readBytes()));
                case 29 -> templateReplyMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.TemplateReplyMessageSpec.decode(inputStream.readBytes()));
                case 30 -> productMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.ProductMessageSpec.decode(inputStream.readBytes()));
                case 31 -> deviceSentMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.server.DeviceSentMessageSpec.decode(inputStream.readBytes()));
                case 32 -> deviceSyncMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.server.DeviceSyncMessageSpec.decode(inputStream.readBytes()));
                case 36 -> listMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.ListMessageSpec.decode(inputStream.readBytes()));
                case 37 -> viewOnceMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.decode(inputStream.readBytes()));
                case 38 -> orderMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.payment.PaymentOrderMessageSpec.decode(inputStream.readBytes()));
                case 39 -> listResponseMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.ListResponseMessageSpec.decode(inputStream.readBytes()));
                case 40 -> ephemeralMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.decode(inputStream.readBytes()));
                case 41 -> invoiceMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.payment.PaymentInvoiceMessageSpec.decode(inputStream.readBytes()));
                case 42 -> buttonsMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.ButtonsMessageSpec.decode(inputStream.readBytes()));
                case 43 -> buttonsResponseMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.ButtonsResponseMessageSpec.decode(inputStream.readBytes()));
                case 44 -> paymentInviteMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.payment.PaymentInviteMessageSpec.decode(inputStream.readBytes()));
                case 45 -> interactiveMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.InteractiveMessageSpec.decode(inputStream.readBytes()));
                case 46 -> reactionMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.ReactionMessageSpec.decode(inputStream.readBytes()));
                case 47 -> stickerSyncMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.server.StickerSyncRMRMessageSpec.decode(inputStream.readBytes()));
                case 48 -> interactiveResponseMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.button.InteractiveResponseMessageSpec.decode(inputStream.readBytes()));
                case 49 -> pollCreationMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.PollCreationMessageSpec.decode(inputStream.readBytes()));
                case 50 -> pollUpdateMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.PollUpdateMessageSpec.decode(inputStream.readBytes()));
                case 51 -> keepInChatMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.KeepInChatMessageSpec.decode(inputStream.readBytes()));
                case 53 -> documentWithCaptionMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.decode(inputStream.readBytes()));
                case 54 -> requestPhoneNumberMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.RequestPhoneNumberMessageSpec.decode(inputStream.readBytes()));
                case 55 -> viewOnceV2Message = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.decode(inputStream.readBytes()));
                case 56 -> encryptedReactionMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.standard.EncryptedReactionMessageSpec.decode(inputStream.readBytes()));
                case 58 -> editedMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.decode(inputStream.readBytes()));
                case 59 -> viewOnceV2ExtensionMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.model.FutureMessageContainerSpec.decode(inputStream.readBytes()));
                case 35 -> deviceInfo = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.DeviceContextInfoSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.model.MessageContainer(textWithNoContextMessage, senderKeyDistributionMessage, imageMessage, contactMessage, locationMessage, textMessage, documentMessage, audioMessage, videoMessage, callMessage, protocolMessage, contactsArrayMessage, highlyStructuredMessage, sendPaymentMessage, liveLocationMessage, requestPaymentMessage, declinePaymentRequestMessage, cancelPaymentRequestMessage, templateMessage, stickerMessage, groupInviteMessage, templateReplyMessage, productMessage, deviceSentMessage, deviceSyncMessage, listMessage, viewOnceMessage, orderMessage, listResponseMessage, ephemeralMessage, invoiceMessage, buttonsMessage, buttonsResponseMessage, paymentInviteMessage, interactiveMessage, reactionMessage, stickerSyncMessage, interactiveResponseMessage, pollCreationMessage, pollUpdateMessage, keepInChatMessage, documentWithCaptionMessage, requestPhoneNumberMessage, viewOnceV2Message, encryptedReactionMessage, editedMessage, viewOnceV2ExtensionMessage, deviceInfo);
    }

}
