package it.auties.whatsapp.model.message.payment;

import it.auties.whatsapp.model.message.payment.DeclinePaymentRequestMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DeclinePaymentRequestMessageSpec {
    public static byte[] encode(DeclinePaymentRequestMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.key()));
      return outputStream.toByteArray();
    }

    public static DeclinePaymentRequestMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey key = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> key = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.payment.DeclinePaymentRequestMessage(key);
    }

}
