package it.auties.whatsapp.model.message.payment;

import it.auties.whatsapp.model.message.payment.PaymentInviteMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PaymentInviteMessageSpec {
    public static byte[] encode(PaymentInviteMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.message.payment.PaymentInviteMessageServiceTypeSpec.encode(protoInputObject.serviceType()));
var expiryTimestamp = protoInputObject.expiryTimestamp();
var expiryTimestamp0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(expiryTimestamp);
if(expiryTimestamp0 != null) {
outputStream.writeUInt64(2, expiryTimestamp0);
}
      return outputStream.toByteArray();
    }

    public static PaymentInviteMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.payment.PaymentInviteMessage.ServiceType serviceType = null;
        java.util.OptionalLong expiryTimestamp = java.util.OptionalLong.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> serviceType = it.auties.whatsapp.model.message.payment.PaymentInviteMessageServiceTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> expiryTimestamp = it.auties.protobuf.extension.OptionalExtension.ofNullableLong(inputStream.readInt64());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.payment.PaymentInviteMessage(serviceType, expiryTimestamp);
    }

}
