package it.auties.whatsapp.model.message.payment;

import it.auties.whatsapp.model.message.payment.PaymentInvoiceMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PaymentInvoiceMessageSpec {
    public static byte[] encode(PaymentInvoiceMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var note = protoInputObject.note();
if(note != null) {
var note0 = note.orElse(null);
if(note0 != null) {
outputStream.writeString(1, note0);
}
}
outputStream.writeString(2, protoInputObject.token());
var paymentAttachmentType = protoInputObject.paymentAttachmentType();
if(paymentAttachmentType != null) {
var paymentAttachmentType0 = paymentAttachmentType.orElse(null);
if(paymentAttachmentType0 != null) {
outputStream.writeInt32(3, it.auties.whatsapp.model.message.payment.PaymentInvoiceMessagePaymentAttachmentTypeSpec.encode(paymentAttachmentType0));
}
}
var mimeType = protoInputObject.mimeType();
if(mimeType != null) {
var mimeType0 = mimeType.orElse(null);
if(mimeType0 != null) {
outputStream.writeString(4, mimeType0);
}
}
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(5, mediaKey0);
}
}
var mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds();
if(mediaKeyTimestampSeconds != null) {
var mediaKeyTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaKeyTimestampSeconds);
if(mediaKeyTimestampSeconds0 != null) {
outputStream.writeUInt64(6, mediaKeyTimestampSeconds0);
}
}
var mediaSha256 = protoInputObject.mediaSha256();
if(mediaSha256 != null) {
var mediaSha2560 = mediaSha256.orElse(null);
if(mediaSha2560 != null) {
outputStream.writeBytes(7, mediaSha2560);
}
}
var mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256();
if(mediaEncryptedSha256 != null) {
var mediaEncryptedSha2560 = mediaEncryptedSha256.orElse(null);
if(mediaEncryptedSha2560 != null) {
outputStream.writeBytes(8, mediaEncryptedSha2560);
}
}
var mediaDirectPath = protoInputObject.mediaDirectPath();
if(mediaDirectPath != null) {
var mediaDirectPath0 = mediaDirectPath.orElse(null);
if(mediaDirectPath0 != null) {
outputStream.writeString(9, mediaDirectPath0);
}
}
var thumbnail = protoInputObject.thumbnail();
if(thumbnail != null) {
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(10, thumbnail0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static PaymentInvoiceMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String note = null;
        java.lang.String token = null;
        it.auties.whatsapp.model.message.payment.PaymentInvoiceMessage.PaymentAttachmentType paymentAttachmentType = null;
        java.lang.String mimeType = null;
        byte[] mediaKey = null;
        java.lang.Long mediaKeyTimestampSeconds = null;
        byte[] mediaSha256 = null;
        byte[] mediaEncryptedSha256 = null;
        java.lang.String mediaDirectPath = null;
        byte[] thumbnail = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> note = inputStream.readString();
                case 2 -> token = inputStream.readString();
                case 3 -> paymentAttachmentType = it.auties.whatsapp.model.message.payment.PaymentInvoiceMessagePaymentAttachmentTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 4 -> mimeType = inputStream.readString();
                case 5 -> mediaKey = inputStream.readBytes();
                case 6 -> mediaKeyTimestampSeconds = inputStream.readInt64();
                case 7 -> mediaSha256 = inputStream.readBytes();
                case 8 -> mediaEncryptedSha256 = inputStream.readBytes();
                case 9 -> mediaDirectPath = inputStream.readString();
                case 10 -> thumbnail = inputStream.readBytes();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.payment.PaymentInvoiceMessage(note, token, paymentAttachmentType, mimeType, mediaKey, mediaKeyTimestampSeconds, mediaSha256, mediaEncryptedSha256, mediaDirectPath, thumbnail, contextInfo);
    }

}
