package it.auties.whatsapp.model.message.server;

import it.auties.whatsapp.model.message.server.DeviceSyncMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DeviceSyncMessageSpec {
    public static byte[] encode(DeviceSyncMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.serializedXmlBytes());
      return outputStream.toByteArray();
    }

    public static DeviceSyncMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] serializedXmlBytes = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> serializedXmlBytes = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.server.DeviceSyncMessage(serializedXmlBytes);
    }

}
