package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.EncryptedReactionMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class EncryptedReactionMessageSpec {
    public static byte[] encode(EncryptedReactionMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.targetMessageKey()));
outputStream.writeBytes(2, protoInputObject.encPayload());
outputStream.writeBytes(3, protoInputObject.encIv());
      return outputStream.toByteArray();
    }

    public static EncryptedReactionMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey targetMessageKey = null;
        byte[] encPayload = null;
        byte[] encIv = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> targetMessageKey = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 2 -> encPayload = inputStream.readBytes();
                case 3 -> encIv = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.EncryptedReactionMessage(targetMessageKey, encPayload, encIv);
    }

}
