package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.GroupInviteMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class GroupInviteMessageSpec {
    public static byte[] encode(GroupInviteMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var group = protoInputObject.group();
if(group != null) {
var group0 = group.toProtobufValue();
if(group0 != null) {
outputStream.writeString(1, group0);
}
}
outputStream.writeString(2, protoInputObject.code());
outputStream.writeUInt64(3, protoInputObject.expirationSeconds());
outputStream.writeString(4, protoInputObject.groupName());
var thumbnail = protoInputObject.thumbnail();
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(5, thumbnail0);
}
var caption = protoInputObject.caption();
var caption0 = caption.orElse(null);
if(caption0 != null) {
outputStream.writeString(6, caption0);
}
var contextInfo = protoInputObject.contextInfo();
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(7, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
outputStream.writeInt32(8, it.auties.whatsapp.model.message.standard.GroupInviteMessageTypeSpec.encode(protoInputObject.groupType()));
      return outputStream.toByteArray();
    }

    public static GroupInviteMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid group = null;
        java.lang.String code = null;
        long expirationSeconds = 0l;
        java.lang.String groupName = null;
        java.util.Optional<byte[]> thumbnail = java.util.Optional.empty();
        java.util.Optional<java.lang.String> caption = java.util.Optional.empty();
        java.util.Optional<it.auties.whatsapp.model.info.ContextInfo> contextInfo = java.util.Optional.empty();
        it.auties.whatsapp.model.message.standard.GroupInviteMessage.Type groupType = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> group = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> code = inputStream.readString();
                case 3 -> expirationSeconds = inputStream.readInt64();
                case 4 -> groupName = inputStream.readString();
                case 5 -> thumbnail = java.util.Optional.ofNullable(inputStream.readBytes());
                case 6 -> caption = java.util.Optional.ofNullable(inputStream.readString());
                case 7 -> contextInfo = java.util.Optional.ofNullable(it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes()));
                case 8 -> groupType = it.auties.whatsapp.model.message.standard.GroupInviteMessageTypeSpec.decode(inputStream.readInt32()).orElse(null);
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.GroupInviteMessage(group, code, expirationSeconds, groupName, thumbnail, caption, contextInfo, groupType);
    }

}
